<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Agency ServiceType
 * @subpackage Services
 */
class Agency extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AgencyFundsTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AgencyFundsTransfer $parameters
     * @return \StructType\AgencyFundsTransferResponse|bool
     */
    public function AgencyFundsTransfer(\StructType\AgencyFundsTransfer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AgencyFundsTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AgencyFundsTransferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
