<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewAssociateToReservation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewAssociateToReservation
 * @subpackage Structs
 */
class ViewAssociateToReservation extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Result;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATA;
    /**
     * Constructor method for ViewAssociateToReservation
     * @uses ViewAssociateToReservation::setResult()
     * @uses ViewAssociateToReservation::setConfirmationNumber()
     * @uses ViewAssociateToReservation::setIATA()
     * @param string $result
     * @param string $confirmationNumber
     * @param string $iATA
     */
    public function __construct($result = null, $confirmationNumber = null, $iATA = null)
    {
        $this
            ->setResult($result)
            ->setConfirmationNumber($confirmationNumber)
            ->setIATA($iATA);
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\ViewAssociateToReservation
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ViewAssociateToReservation
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get IATA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATA()
    {
        return isset($this->IATA) ? $this->IATA : null;
    }
    /**
     * Set IATA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATA
     * @return \StructType\ViewAssociateToReservation
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        if (is_null($iATA) || (is_array($iATA) && empty($iATA))) {
            unset($this->IATA);
        } else {
            $this->IATA = $iATA;
        }
        return $this;
    }
}
