<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewAgencyListItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewAgencyListItem
 * @subpackage Structs
 */
class ViewAgencyListItem extends AbstractStructBase
{
    /**
     * The IataCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IataCode;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The AvailableBalance
     * @var float
     */
    public $AvailableBalance;
    /**
     * The NumberOfBookings
     * @var int
     */
    public $NumberOfBookings;
    /**
     * The TravelAgentStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelAgentStatus;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewAgencyListItem
     * @uses ViewAgencyListItem::setIataCode()
     * @uses ViewAgencyListItem::setAgencyName()
     * @uses ViewAgencyListItem::setCurrencyCode()
     * @uses ViewAgencyListItem::setAvailableBalance()
     * @uses ViewAgencyListItem::setNumberOfBookings()
     * @uses ViewAgencyListItem::setTravelAgentStatus()
     * @uses ViewAgencyListItem::setExceptions()
     * @param string $iataCode
     * @param string $agencyName
     * @param string $currencyCode
     * @param float $availableBalance
     * @param int $numberOfBookings
     * @param string $travelAgentStatus
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct($iataCode = null, $agencyName = null, $currencyCode = null, $availableBalance = null, $numberOfBookings = null, $travelAgentStatus = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setIataCode($iataCode)
            ->setAgencyName($agencyName)
            ->setCurrencyCode($currencyCode)
            ->setAvailableBalance($availableBalance)
            ->setNumberOfBookings($numberOfBookings)
            ->setTravelAgentStatus($travelAgentStatus)
            ->setExceptions($exceptions);
    }
    /**
     * Get IataCode value
     * @return string|null
     */
    public function getIataCode()
    {
        return $this->IataCode;
    }
    /**
     * Set IataCode value
     * @param string $iataCode
     * @return \StructType\ViewAgencyListItem
     */
    public function setIataCode($iataCode = null)
    {
        // validation for constraint: string
        if (!is_null($iataCode) && !is_string($iataCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataCode, true), gettype($iataCode)), __LINE__);
        }
        $this->IataCode = $iataCode;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\ViewAgencyListItem
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ViewAgencyListItem
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get AvailableBalance value
     * @return float|null
     */
    public function getAvailableBalance()
    {
        return $this->AvailableBalance;
    }
    /**
     * Set AvailableBalance value
     * @param float $availableBalance
     * @return \StructType\ViewAgencyListItem
     */
    public function setAvailableBalance($availableBalance = null)
    {
        // validation for constraint: float
        if (!is_null($availableBalance) && !(is_float($availableBalance) || is_numeric($availableBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($availableBalance, true), gettype($availableBalance)), __LINE__);
        }
        $this->AvailableBalance = $availableBalance;
        return $this;
    }
    /**
     * Get NumberOfBookings value
     * @return int|null
     */
    public function getNumberOfBookings()
    {
        return $this->NumberOfBookings;
    }
    /**
     * Set NumberOfBookings value
     * @param int $numberOfBookings
     * @return \StructType\ViewAgencyListItem
     */
    public function setNumberOfBookings($numberOfBookings = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBookings) && !(is_int($numberOfBookings) || ctype_digit($numberOfBookings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBookings, true), gettype($numberOfBookings)), __LINE__);
        }
        $this->NumberOfBookings = $numberOfBookings;
        return $this;
    }
    /**
     * Get TravelAgentStatus value
     * @return string|null
     */
    public function getTravelAgentStatus()
    {
        return $this->TravelAgentStatus;
    }
    /**
     * Set TravelAgentStatus value
     * @param string $travelAgentStatus
     * @return \StructType\ViewAgencyListItem
     */
    public function setTravelAgentStatus($travelAgentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgentStatus) && !is_string($travelAgentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgentStatus, true), gettype($travelAgentStatus)), __LINE__);
        }
        $this->TravelAgentStatus = $travelAgentStatus;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewAgencyListItem
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
