<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewAgencyInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewAgencyInfo
 * @subpackage Structs
 */
class ViewAgencyInfo extends AbstractStructBase
{
    /**
     * The IataCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IataCode;
    /**
     * The PersonOrgId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PersonOrgId;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContactName;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ParentIataCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ParentIataCode;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountExpiration
     * @var string
     */
    public $AccountExpiration;
    /**
     * The Commission
     * @var float
     */
    public $Commission;
    /**
     * The CreditLimit
     * @var float
     */
    public $CreditLimit;
    /**
     * The FetExempt
     * @var bool
     */
    public $FetExempt;
    /**
     * The BankNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BankNumber;
    /**
     * The TravelAgentStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelAgentStatus;
    /**
     * The ConsortTravalAgentId
     * @var int
     */
    public $ConsortTravalAgentId;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountId;
    /**
     * The FederalId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FederalId;
    /**
     * The EmailReceipt
     * @var bool
     */
    public $EmailReceipt;
    /**
     * The FaxReceipt
     * @var bool
     */
    public $FaxReceipt;
    /**
     * The MailReceipt
     * @var bool
     */
    public $MailReceipt;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The Prepaid
     * @var bool
     */
    public $Prepaid;
    /**
     * The TravelAgentTypeId
     * @var int
     */
    public $TravelAgentTypeId;
    /**
     * The CanViewAllPnrs
     * @var bool
     */
    public $CanViewAllPnrs;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The TravelAgentUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelAgentUserName;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewAgencyInfo
     * @uses ViewAgencyInfo::setIataCode()
     * @uses ViewAgencyInfo::setPersonOrgId()
     * @uses ViewAgencyInfo::setContactName()
     * @uses ViewAgencyInfo::setCurrencyCode()
     * @uses ViewAgencyInfo::setParentIataCode()
     * @uses ViewAgencyInfo::setAccountNumber()
     * @uses ViewAgencyInfo::setAccountName()
     * @uses ViewAgencyInfo::setAccountExpiration()
     * @uses ViewAgencyInfo::setCommission()
     * @uses ViewAgencyInfo::setCreditLimit()
     * @uses ViewAgencyInfo::setFetExempt()
     * @uses ViewAgencyInfo::setBankNumber()
     * @uses ViewAgencyInfo::setTravelAgentStatus()
     * @uses ViewAgencyInfo::setConsortTravalAgentId()
     * @uses ViewAgencyInfo::setFareBasisCode()
     * @uses ViewAgencyInfo::setAccountId()
     * @uses ViewAgencyInfo::setFederalId()
     * @uses ViewAgencyInfo::setEmailReceipt()
     * @uses ViewAgencyInfo::setFaxReceipt()
     * @uses ViewAgencyInfo::setMailReceipt()
     * @uses ViewAgencyInfo::setComments()
     * @uses ViewAgencyInfo::setPrepaid()
     * @uses ViewAgencyInfo::setTravelAgentTypeId()
     * @uses ViewAgencyInfo::setCanViewAllPnrs()
     * @uses ViewAgencyInfo::setAddress1()
     * @uses ViewAgencyInfo::setAddress2()
     * @uses ViewAgencyInfo::setCompanyName()
     * @uses ViewAgencyInfo::setCity()
     * @uses ViewAgencyInfo::setState()
     * @uses ViewAgencyInfo::setZipCode()
     * @uses ViewAgencyInfo::setCountry()
     * @uses ViewAgencyInfo::setPhone()
     * @uses ViewAgencyInfo::setEmail()
     * @uses ViewAgencyInfo::setFax()
     * @uses ViewAgencyInfo::setTravelAgentUserName()
     * @uses ViewAgencyInfo::setExceptions()
     * @param string $iataCode
     * @param string $personOrgId
     * @param string $contactName
     * @param string $currencyCode
     * @param string $parentIataCode
     * @param string $accountNumber
     * @param string $accountName
     * @param string $accountExpiration
     * @param float $commission
     * @param float $creditLimit
     * @param bool $fetExempt
     * @param string $bankNumber
     * @param string $travelAgentStatus
     * @param int $consortTravalAgentId
     * @param string $fareBasisCode
     * @param string $accountId
     * @param string $federalId
     * @param bool $emailReceipt
     * @param bool $faxReceipt
     * @param bool $mailReceipt
     * @param string $comments
     * @param bool $prepaid
     * @param int $travelAgentTypeId
     * @param bool $canViewAllPnrs
     * @param string $address1
     * @param string $address2
     * @param string $companyName
     * @param string $city
     * @param string $state
     * @param string $zipCode
     * @param string $country
     * @param string $phone
     * @param string $email
     * @param string $fax
     * @param string $travelAgentUserName
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct($iataCode = null, $personOrgId = null, $contactName = null, $currencyCode = null, $parentIataCode = null, $accountNumber = null, $accountName = null, $accountExpiration = null, $commission = null, $creditLimit = null, $fetExempt = null, $bankNumber = null, $travelAgentStatus = null, $consortTravalAgentId = null, $fareBasisCode = null, $accountId = null, $federalId = null, $emailReceipt = null, $faxReceipt = null, $mailReceipt = null, $comments = null, $prepaid = null, $travelAgentTypeId = null, $canViewAllPnrs = null, $address1 = null, $address2 = null, $companyName = null, $city = null, $state = null, $zipCode = null, $country = null, $phone = null, $email = null, $fax = null, $travelAgentUserName = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setIataCode($iataCode)
            ->setPersonOrgId($personOrgId)
            ->setContactName($contactName)
            ->setCurrencyCode($currencyCode)
            ->setParentIataCode($parentIataCode)
            ->setAccountNumber($accountNumber)
            ->setAccountName($accountName)
            ->setAccountExpiration($accountExpiration)
            ->setCommission($commission)
            ->setCreditLimit($creditLimit)
            ->setFetExempt($fetExempt)
            ->setBankNumber($bankNumber)
            ->setTravelAgentStatus($travelAgentStatus)
            ->setConsortTravalAgentId($consortTravalAgentId)
            ->setFareBasisCode($fareBasisCode)
            ->setAccountId($accountId)
            ->setFederalId($federalId)
            ->setEmailReceipt($emailReceipt)
            ->setFaxReceipt($faxReceipt)
            ->setMailReceipt($mailReceipt)
            ->setComments($comments)
            ->setPrepaid($prepaid)
            ->setTravelAgentTypeId($travelAgentTypeId)
            ->setCanViewAllPnrs($canViewAllPnrs)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCompanyName($companyName)
            ->setCity($city)
            ->setState($state)
            ->setZipCode($zipCode)
            ->setCountry($country)
            ->setPhone($phone)
            ->setEmail($email)
            ->setFax($fax)
            ->setTravelAgentUserName($travelAgentUserName)
            ->setExceptions($exceptions);
    }
    /**
     * Get IataCode value
     * @return string|null
     */
    public function getIataCode()
    {
        return $this->IataCode;
    }
    /**
     * Set IataCode value
     * @param string $iataCode
     * @return \StructType\ViewAgencyInfo
     */
    public function setIataCode($iataCode = null)
    {
        // validation for constraint: string
        if (!is_null($iataCode) && !is_string($iataCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataCode, true), gettype($iataCode)), __LINE__);
        }
        $this->IataCode = $iataCode;
        return $this;
    }
    /**
     * Get PersonOrgId value
     * @return string|null
     */
    public function getPersonOrgId()
    {
        return $this->PersonOrgId;
    }
    /**
     * Set PersonOrgId value
     * @param string $personOrgId
     * @return \StructType\ViewAgencyInfo
     */
    public function setPersonOrgId($personOrgId = null)
    {
        // validation for constraint: string
        if (!is_null($personOrgId) && !is_string($personOrgId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personOrgId, true), gettype($personOrgId)), __LINE__);
        }
        $this->PersonOrgId = $personOrgId;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\ViewAgencyInfo
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ViewAgencyInfo
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ParentIataCode value
     * @return string|null
     */
    public function getParentIataCode()
    {
        return $this->ParentIataCode;
    }
    /**
     * Set ParentIataCode value
     * @param string $parentIataCode
     * @return \StructType\ViewAgencyInfo
     */
    public function setParentIataCode($parentIataCode = null)
    {
        // validation for constraint: string
        if (!is_null($parentIataCode) && !is_string($parentIataCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentIataCode, true), gettype($parentIataCode)), __LINE__);
        }
        $this->ParentIataCode = $parentIataCode;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\ViewAgencyInfo
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\ViewAgencyInfo
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get AccountExpiration value
     * @return string|null
     */
    public function getAccountExpiration()
    {
        return $this->AccountExpiration;
    }
    /**
     * Set AccountExpiration value
     * @param string $accountExpiration
     * @return \StructType\ViewAgencyInfo
     */
    public function setAccountExpiration($accountExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($accountExpiration) && !is_string($accountExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountExpiration, true), gettype($accountExpiration)), __LINE__);
        }
        $this->AccountExpiration = $accountExpiration;
        return $this;
    }
    /**
     * Get Commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param float $commission
     * @return \StructType\ViewAgencyInfo
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get CreditLimit value
     * @return float|null
     */
    public function getCreditLimit()
    {
        return $this->CreditLimit;
    }
    /**
     * Set CreditLimit value
     * @param float $creditLimit
     * @return \StructType\ViewAgencyInfo
     */
    public function setCreditLimit($creditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($creditLimit) && !(is_float($creditLimit) || is_numeric($creditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditLimit, true), gettype($creditLimit)), __LINE__);
        }
        $this->CreditLimit = $creditLimit;
        return $this;
    }
    /**
     * Get FetExempt value
     * @return bool|null
     */
    public function getFetExempt()
    {
        return $this->FetExempt;
    }
    /**
     * Set FetExempt value
     * @param bool $fetExempt
     * @return \StructType\ViewAgencyInfo
     */
    public function setFetExempt($fetExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($fetExempt) && !is_bool($fetExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fetExempt, true), gettype($fetExempt)), __LINE__);
        }
        $this->FetExempt = $fetExempt;
        return $this;
    }
    /**
     * Get BankNumber value
     * @return string|null
     */
    public function getBankNumber()
    {
        return $this->BankNumber;
    }
    /**
     * Set BankNumber value
     * @param string $bankNumber
     * @return \StructType\ViewAgencyInfo
     */
    public function setBankNumber($bankNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankNumber) && !is_string($bankNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankNumber, true), gettype($bankNumber)), __LINE__);
        }
        $this->BankNumber = $bankNumber;
        return $this;
    }
    /**
     * Get TravelAgentStatus value
     * @return string|null
     */
    public function getTravelAgentStatus()
    {
        return $this->TravelAgentStatus;
    }
    /**
     * Set TravelAgentStatus value
     * @param string $travelAgentStatus
     * @return \StructType\ViewAgencyInfo
     */
    public function setTravelAgentStatus($travelAgentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgentStatus) && !is_string($travelAgentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgentStatus, true), gettype($travelAgentStatus)), __LINE__);
        }
        $this->TravelAgentStatus = $travelAgentStatus;
        return $this;
    }
    /**
     * Get ConsortTravalAgentId value
     * @return int|null
     */
    public function getConsortTravalAgentId()
    {
        return $this->ConsortTravalAgentId;
    }
    /**
     * Set ConsortTravalAgentId value
     * @param int $consortTravalAgentId
     * @return \StructType\ViewAgencyInfo
     */
    public function setConsortTravalAgentId($consortTravalAgentId = null)
    {
        // validation for constraint: int
        if (!is_null($consortTravalAgentId) && !(is_int($consortTravalAgentId) || ctype_digit($consortTravalAgentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consortTravalAgentId, true), gettype($consortTravalAgentId)), __LINE__);
        }
        $this->ConsortTravalAgentId = $consortTravalAgentId;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\ViewAgencyInfo
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get AccountId value
     * @return string|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param string $accountId
     * @return \StructType\ViewAgencyInfo
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get FederalId value
     * @return string|null
     */
    public function getFederalId()
    {
        return $this->FederalId;
    }
    /**
     * Set FederalId value
     * @param string $federalId
     * @return \StructType\ViewAgencyInfo
     */
    public function setFederalId($federalId = null)
    {
        // validation for constraint: string
        if (!is_null($federalId) && !is_string($federalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($federalId, true), gettype($federalId)), __LINE__);
        }
        $this->FederalId = $federalId;
        return $this;
    }
    /**
     * Get EmailReceipt value
     * @return bool|null
     */
    public function getEmailReceipt()
    {
        return $this->EmailReceipt;
    }
    /**
     * Set EmailReceipt value
     * @param bool $emailReceipt
     * @return \StructType\ViewAgencyInfo
     */
    public function setEmailReceipt($emailReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailReceipt) && !is_bool($emailReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailReceipt, true), gettype($emailReceipt)), __LINE__);
        }
        $this->EmailReceipt = $emailReceipt;
        return $this;
    }
    /**
     * Get FaxReceipt value
     * @return bool|null
     */
    public function getFaxReceipt()
    {
        return $this->FaxReceipt;
    }
    /**
     * Set FaxReceipt value
     * @param bool $faxReceipt
     * @return \StructType\ViewAgencyInfo
     */
    public function setFaxReceipt($faxReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($faxReceipt) && !is_bool($faxReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($faxReceipt, true), gettype($faxReceipt)), __LINE__);
        }
        $this->FaxReceipt = $faxReceipt;
        return $this;
    }
    /**
     * Get MailReceipt value
     * @return bool|null
     */
    public function getMailReceipt()
    {
        return $this->MailReceipt;
    }
    /**
     * Set MailReceipt value
     * @param bool $mailReceipt
     * @return \StructType\ViewAgencyInfo
     */
    public function setMailReceipt($mailReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailReceipt) && !is_bool($mailReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mailReceipt, true), gettype($mailReceipt)), __LINE__);
        }
        $this->MailReceipt = $mailReceipt;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\ViewAgencyInfo
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\ViewAgencyInfo
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get TravelAgentTypeId value
     * @return int|null
     */
    public function getTravelAgentTypeId()
    {
        return $this->TravelAgentTypeId;
    }
    /**
     * Set TravelAgentTypeId value
     * @param int $travelAgentTypeId
     * @return \StructType\ViewAgencyInfo
     */
    public function setTravelAgentTypeId($travelAgentTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($travelAgentTypeId) && !(is_int($travelAgentTypeId) || ctype_digit($travelAgentTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelAgentTypeId, true), gettype($travelAgentTypeId)), __LINE__);
        }
        $this->TravelAgentTypeId = $travelAgentTypeId;
        return $this;
    }
    /**
     * Get CanViewAllPnrs value
     * @return bool|null
     */
    public function getCanViewAllPnrs()
    {
        return $this->CanViewAllPnrs;
    }
    /**
     * Set CanViewAllPnrs value
     * @param bool $canViewAllPnrs
     * @return \StructType\ViewAgencyInfo
     */
    public function setCanViewAllPnrs($canViewAllPnrs = null)
    {
        // validation for constraint: boolean
        if (!is_null($canViewAllPnrs) && !is_bool($canViewAllPnrs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canViewAllPnrs, true), gettype($canViewAllPnrs)), __LINE__);
        }
        $this->CanViewAllPnrs = $canViewAllPnrs;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\ViewAgencyInfo
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\ViewAgencyInfo
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\ViewAgencyInfo
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\ViewAgencyInfo
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\ViewAgencyInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\ViewAgencyInfo
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\ViewAgencyInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\ViewAgencyInfo
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\ViewAgencyInfo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\ViewAgencyInfo
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get TravelAgentUserName value
     * @return string|null
     */
    public function getTravelAgentUserName()
    {
        return $this->TravelAgentUserName;
    }
    /**
     * Set TravelAgentUserName value
     * @param string $travelAgentUserName
     * @return \StructType\ViewAgencyInfo
     */
    public function setTravelAgentUserName($travelAgentUserName = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgentUserName) && !is_string($travelAgentUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgentUserName, true), gettype($travelAgentUserName)), __LINE__);
        }
        $this->TravelAgentUserName = $travelAgentUserName;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewAgencyInfo
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
