<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelAgencyPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TravelAgencyPNR
 * @subpackage Structs
 */
class TravelAgencyPNR extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookDate
     * @var string
     */
    public $BookDate;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The ReservationCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReservationCurrency;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The FromAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FromAirport;
    /**
     * The ToAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ToAirport;
    /**
     * The Stops
     * @var int
     */
    public $Stops;
    /**
     * The ReservationSegmentStatus
     * @var int
     */
    public $ReservationSegmentStatus;
    /**
     * The BookingAgent
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingAgent;
    /**
     * The TicketingTimeLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketingTimeLimit;
    /**
     * The ReservationBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ReservationBalance;
    /**
     * The Passengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPassenger
     */
    public $Passengers;
    /**
     * The HistoricConfirmationNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HistoricConfirmationNum;
    /**
     * Constructor method for TravelAgencyPNR
     * @uses TravelAgencyPNR::setSeriesNumber()
     * @uses TravelAgencyPNR::setConfirmationNumber()
     * @uses TravelAgencyPNR::setBookDate()
     * @uses TravelAgencyPNR::setIATANumber()
     * @uses TravelAgencyPNR::setReservationCurrency()
     * @uses TravelAgencyPNR::setLogicalFlightID()
     * @uses TravelAgencyPNR::setDepartureDate()
     * @uses TravelAgencyPNR::setFlightNumber()
     * @uses TravelAgencyPNR::setFromAirport()
     * @uses TravelAgencyPNR::setToAirport()
     * @uses TravelAgencyPNR::setStops()
     * @uses TravelAgencyPNR::setReservationSegmentStatus()
     * @uses TravelAgencyPNR::setBookingAgent()
     * @uses TravelAgencyPNR::setTicketingTimeLimit()
     * @uses TravelAgencyPNR::setReservationBalance()
     * @uses TravelAgencyPNR::setPassengers()
     * @uses TravelAgencyPNR::setHistoricConfirmationNum()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $bookDate
     * @param string $iATANumber
     * @param string $reservationCurrency
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param string $flightNumber
     * @param string $fromAirport
     * @param string $toAirport
     * @param int $stops
     * @param int $reservationSegmentStatus
     * @param string $bookingAgent
     * @param string $ticketingTimeLimit
     * @param float $reservationBalance
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @param string $historicConfirmationNum
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $bookDate = null, $iATANumber = null, $reservationCurrency = null, $logicalFlightID = null, $departureDate = null, $flightNumber = null, $fromAirport = null, $toAirport = null, $stops = null, $reservationSegmentStatus = null, $bookingAgent = null, $ticketingTimeLimit = null, $reservationBalance = null, \ArrayType\ArrayOfPassenger $passengers = null, $historicConfirmationNum = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setBookDate($bookDate)
            ->setIATANumber($iATANumber)
            ->setReservationCurrency($reservationCurrency)
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setFlightNumber($flightNumber)
            ->setFromAirport($fromAirport)
            ->setToAirport($toAirport)
            ->setStops($stops)
            ->setReservationSegmentStatus($reservationSegmentStatus)
            ->setBookingAgent($bookingAgent)
            ->setTicketingTimeLimit($ticketingTimeLimit)
            ->setReservationBalance($reservationBalance)
            ->setPassengers($passengers)
            ->setHistoricConfirmationNum($historicConfirmationNum);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\TravelAgencyPNR
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\TravelAgencyPNR
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get BookDate value
     * @return string|null
     */
    public function getBookDate()
    {
        return $this->BookDate;
    }
    /**
     * Set BookDate value
     * @param string $bookDate
     * @return \StructType\TravelAgencyPNR
     */
    public function setBookDate($bookDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookDate) && !is_string($bookDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookDate, true), gettype($bookDate)), __LINE__);
        }
        $this->BookDate = $bookDate;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\TravelAgencyPNR
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get ReservationCurrency value
     * @return string|null
     */
    public function getReservationCurrency()
    {
        return $this->ReservationCurrency;
    }
    /**
     * Set ReservationCurrency value
     * @param string $reservationCurrency
     * @return \StructType\TravelAgencyPNR
     */
    public function setReservationCurrency($reservationCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($reservationCurrency) && !is_string($reservationCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationCurrency, true), gettype($reservationCurrency)), __LINE__);
        }
        $this->ReservationCurrency = $reservationCurrency;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\TravelAgencyPNR
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\TravelAgencyPNR
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\TravelAgencyPNR
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get FromAirport value
     * @return string|null
     */
    public function getFromAirport()
    {
        return $this->FromAirport;
    }
    /**
     * Set FromAirport value
     * @param string $fromAirport
     * @return \StructType\TravelAgencyPNR
     */
    public function setFromAirport($fromAirport = null)
    {
        // validation for constraint: string
        if (!is_null($fromAirport) && !is_string($fromAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromAirport, true), gettype($fromAirport)), __LINE__);
        }
        $this->FromAirport = $fromAirport;
        return $this;
    }
    /**
     * Get ToAirport value
     * @return string|null
     */
    public function getToAirport()
    {
        return $this->ToAirport;
    }
    /**
     * Set ToAirport value
     * @param string $toAirport
     * @return \StructType\TravelAgencyPNR
     */
    public function setToAirport($toAirport = null)
    {
        // validation for constraint: string
        if (!is_null($toAirport) && !is_string($toAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAirport, true), gettype($toAirport)), __LINE__);
        }
        $this->ToAirport = $toAirport;
        return $this;
    }
    /**
     * Get Stops value
     * @return int|null
     */
    public function getStops()
    {
        return $this->Stops;
    }
    /**
     * Set Stops value
     * @param int $stops
     * @return \StructType\TravelAgencyPNR
     */
    public function setStops($stops = null)
    {
        // validation for constraint: int
        if (!is_null($stops) && !(is_int($stops) || ctype_digit($stops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stops, true), gettype($stops)), __LINE__);
        }
        $this->Stops = $stops;
        return $this;
    }
    /**
     * Get ReservationSegmentStatus value
     * @return int|null
     */
    public function getReservationSegmentStatus()
    {
        return $this->ReservationSegmentStatus;
    }
    /**
     * Set ReservationSegmentStatus value
     * @param int $reservationSegmentStatus
     * @return \StructType\TravelAgencyPNR
     */
    public function setReservationSegmentStatus($reservationSegmentStatus = null)
    {
        // validation for constraint: int
        if (!is_null($reservationSegmentStatus) && !(is_int($reservationSegmentStatus) || ctype_digit($reservationSegmentStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationSegmentStatus, true), gettype($reservationSegmentStatus)), __LINE__);
        }
        $this->ReservationSegmentStatus = $reservationSegmentStatus;
        return $this;
    }
    /**
     * Get BookingAgent value
     * @return string|null
     */
    public function getBookingAgent()
    {
        return $this->BookingAgent;
    }
    /**
     * Set BookingAgent value
     * @param string $bookingAgent
     * @return \StructType\TravelAgencyPNR
     */
    public function setBookingAgent($bookingAgent = null)
    {
        // validation for constraint: string
        if (!is_null($bookingAgent) && !is_string($bookingAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingAgent, true), gettype($bookingAgent)), __LINE__);
        }
        $this->BookingAgent = $bookingAgent;
        return $this;
    }
    /**
     * Get TicketingTimeLimit value
     * @return string|null
     */
    public function getTicketingTimeLimit()
    {
        return $this->TicketingTimeLimit;
    }
    /**
     * Set TicketingTimeLimit value
     * @param string $ticketingTimeLimit
     * @return \StructType\TravelAgencyPNR
     */
    public function setTicketingTimeLimit($ticketingTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingTimeLimit) && !is_string($ticketingTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingTimeLimit, true), gettype($ticketingTimeLimit)), __LINE__);
        }
        $this->TicketingTimeLimit = $ticketingTimeLimit;
        return $this;
    }
    /**
     * Get ReservationBalance value
     * @return float|null
     */
    public function getReservationBalance()
    {
        return $this->ReservationBalance;
    }
    /**
     * Set ReservationBalance value
     * @param float $reservationBalance
     * @return \StructType\TravelAgencyPNR
     */
    public function setReservationBalance($reservationBalance = null)
    {
        // validation for constraint: float
        if (!is_null($reservationBalance) && !(is_float($reservationBalance) || is_numeric($reservationBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reservationBalance, true), gettype($reservationBalance)), __LINE__);
        }
        $this->ReservationBalance = $reservationBalance;
        return $this;
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPassenger|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @return \StructType\TravelAgencyPNR
     */
    public function setPassengers(\ArrayType\ArrayOfPassenger $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get HistoricConfirmationNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoricConfirmationNum()
    {
        return isset($this->HistoricConfirmationNum) ? $this->HistoricConfirmationNum : null;
    }
    /**
     * Set HistoricConfirmationNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historicConfirmationNum
     * @return \StructType\TravelAgencyPNR
     */
    public function setHistoricConfirmationNum($historicConfirmationNum = null)
    {
        // validation for constraint: string
        if (!is_null($historicConfirmationNum) && !is_string($historicConfirmationNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historicConfirmationNum, true), gettype($historicConfirmationNum)), __LINE__);
        }
        if (is_null($historicConfirmationNum) || (is_array($historicConfirmationNum) && empty($historicConfirmationNum))) {
            unset($this->HistoricConfirmationNum);
        } else {
            $this->HistoricConfirmationNum = $historicConfirmationNum;
        }
        return $this;
    }
}
