<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveBookingsWithPaymentsPending StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveBookingsWithPaymentsPending
 * @subpackage Structs
 */
class RetrieveBookingsWithPaymentsPending extends TransactionInfo
{
    /**
     * The RetrieveBookingsWithPaymentsPendingRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveBookingsWithPaymentsPending
     */
    public $RetrieveBookingsWithPaymentsPendingRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The IncludeChildAgency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeChildAgency;
    /**
     * Constructor method for RetrieveBookingsWithPaymentsPending
     * @uses RetrieveBookingsWithPaymentsPending::setRetrieveBookingsWithPaymentsPendingRequest()
     * @uses RetrieveBookingsWithPaymentsPending::setIATANumber()
     * @uses RetrieveBookingsWithPaymentsPending::setIncludeChildAgency()
     * @param \StructType\RetrieveBookingsWithPaymentsPending $retrieveBookingsWithPaymentsPendingRequest
     * @param string $iATANumber
     * @param string $includeChildAgency
     */
    public function __construct(\StructType\RetrieveBookingsWithPaymentsPending $retrieveBookingsWithPaymentsPendingRequest = null, $iATANumber = null, $includeChildAgency = null)
    {
        $this
            ->setRetrieveBookingsWithPaymentsPendingRequest($retrieveBookingsWithPaymentsPendingRequest)
            ->setIATANumber($iATANumber)
            ->setIncludeChildAgency($includeChildAgency);
    }
    /**
     * Get RetrieveBookingsWithPaymentsPendingRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveBookingsWithPaymentsPending|null
     */
    public function getRetrieveBookingsWithPaymentsPendingRequest()
    {
        return isset($this->RetrieveBookingsWithPaymentsPendingRequest) ? $this->RetrieveBookingsWithPaymentsPendingRequest : null;
    }
    /**
     * Set RetrieveBookingsWithPaymentsPendingRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveBookingsWithPaymentsPending $retrieveBookingsWithPaymentsPendingRequest
     * @return \StructType\RetrieveBookingsWithPaymentsPending
     */
    public function setRetrieveBookingsWithPaymentsPendingRequest(\StructType\RetrieveBookingsWithPaymentsPending $retrieveBookingsWithPaymentsPendingRequest = null)
    {
        if (is_null($retrieveBookingsWithPaymentsPendingRequest) || (is_array($retrieveBookingsWithPaymentsPendingRequest) && empty($retrieveBookingsWithPaymentsPendingRequest))) {
            unset($this->RetrieveBookingsWithPaymentsPendingRequest);
        } else {
            $this->RetrieveBookingsWithPaymentsPendingRequest = $retrieveBookingsWithPaymentsPendingRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\RetrieveBookingsWithPaymentsPending
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
    /**
     * Get IncludeChildAgency value
     * @return string|null
     */
    public function getIncludeChildAgency()
    {
        return $this->IncludeChildAgency;
    }
    /**
     * Set IncludeChildAgency value
     * @uses \EnumType\Enumerations_AnswerTypes::valueIsValid()
     * @uses \EnumType\Enumerations_AnswerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeChildAgency
     * @return \StructType\RetrieveBookingsWithPaymentsPending
     */
    public function setIncludeChildAgency($includeChildAgency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AnswerTypes::valueIsValid($includeChildAgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AnswerTypes', is_array($includeChildAgency) ? implode(', ', $includeChildAgency) : var_export($includeChildAgency, true), implode(', ', \EnumType\Enumerations_AnswerTypes::getValidValues())), __LINE__);
        }
        $this->IncludeChildAgency = $includeChildAgency;
        return $this;
    }
}
