<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgencyCommission StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgencyCommission
 * @subpackage Structs
 */
class RetrieveAgencyCommission extends TransactionInfo
{
    /**
     * The RetrieveAgencyCommissionRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgencyCommission
     */
    public $RetrieveAgencyCommissionRequest;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for RetrieveAgencyCommission
     * @uses RetrieveAgencyCommission::setRetrieveAgencyCommissionRequest()
     * @uses RetrieveAgencyCommission::setCurrencyCode()
     * @param \StructType\RetrieveAgencyCommission $retrieveAgencyCommissionRequest
     * @param string $currencyCode
     */
    public function __construct(\StructType\RetrieveAgencyCommission $retrieveAgencyCommissionRequest = null, $currencyCode = null)
    {
        $this
            ->setRetrieveAgencyCommissionRequest($retrieveAgencyCommissionRequest)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get RetrieveAgencyCommissionRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgencyCommission|null
     */
    public function getRetrieveAgencyCommissionRequest()
    {
        return isset($this->RetrieveAgencyCommissionRequest) ? $this->RetrieveAgencyCommissionRequest : null;
    }
    /**
     * Set RetrieveAgencyCommissionRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgencyCommission $retrieveAgencyCommissionRequest
     * @return \StructType\RetrieveAgencyCommission
     */
    public function setRetrieveAgencyCommissionRequest(\StructType\RetrieveAgencyCommission $retrieveAgencyCommissionRequest = null)
    {
        if (is_null($retrieveAgencyCommissionRequest) || (is_array($retrieveAgencyCommissionRequest) && empty($retrieveAgencyCommissionRequest))) {
            unset($this->RetrieveAgencyCommissionRequest);
        } else {
            $this->RetrieveAgencyCommissionRequest = $retrieveAgencyCommissionRequest;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyCode
     * @return \StructType\RetrieveAgencyCommission
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currencyCode) ? implode(', ', $currencyCode) : var_export($currencyCode, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
}
