<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyAgent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyAgent
 * @subpackage Structs
 */
class ModifyAgent extends TransactionInfo
{
    /**
     * The ModifyAgentRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ModifyAgent
     */
    public $ModifyAgentRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The Status
     * @var int
     */
    public $Status;
    /**
     * The AgentUsername
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentUsername;
    /**
     * The AgentFirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentFirstName;
    /**
     * The AgentLastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentLastName;
    /**
     * The AgentAddress1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentAddress1;
    /**
     * The AgentAddress2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentAddress2;
    /**
     * The AgentCity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentCity;
    /**
     * The AgentState
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentState;
    /**
     * The AgentPostalCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentPostalCode;
    /**
     * The AgencyCountry
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyCountry;
    /**
     * The AgentEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgentEmail;
    /**
     * The TaContactInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfTAContactInfo
     */
    public $TaContactInfos;
    /**
     * The ActionSuccessful
     * @var bool
     */
    public $ActionSuccessful;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ModifyAgent
     * @uses ModifyAgent::setModifyAgentRequest()
     * @uses ModifyAgent::setActionType()
     * @uses ModifyAgent::setIATANumber()
     * @uses ModifyAgent::setStatus()
     * @uses ModifyAgent::setAgentUsername()
     * @uses ModifyAgent::setAgentFirstName()
     * @uses ModifyAgent::setAgentLastName()
     * @uses ModifyAgent::setAgentAddress1()
     * @uses ModifyAgent::setAgentAddress2()
     * @uses ModifyAgent::setAgentCity()
     * @uses ModifyAgent::setAgentState()
     * @uses ModifyAgent::setAgentPostalCode()
     * @uses ModifyAgent::setAgencyCountry()
     * @uses ModifyAgent::setAgentEmail()
     * @uses ModifyAgent::setTaContactInfos()
     * @uses ModifyAgent::setActionSuccessful()
     * @uses ModifyAgent::setExceptions()
     * @param \StructType\ModifyAgent $modifyAgentRequest
     * @param string $actionType
     * @param string $iATANumber
     * @param int $status
     * @param string $agentUsername
     * @param string $agentFirstName
     * @param string $agentLastName
     * @param string $agentAddress1
     * @param string $agentAddress2
     * @param string $agentCity
     * @param string $agentState
     * @param string $agentPostalCode
     * @param string $agencyCountry
     * @param string $agentEmail
     * @param \ArrayType\ArrayOfTAContactInfo $taContactInfos
     * @param bool $actionSuccessful
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\ModifyAgent $modifyAgentRequest = null, $actionType = null, $iATANumber = null, $status = null, $agentUsername = null, $agentFirstName = null, $agentLastName = null, $agentAddress1 = null, $agentAddress2 = null, $agentCity = null, $agentState = null, $agentPostalCode = null, $agencyCountry = null, $agentEmail = null, \ArrayType\ArrayOfTAContactInfo $taContactInfos = null, $actionSuccessful = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setModifyAgentRequest($modifyAgentRequest)
            ->setActionType($actionType)
            ->setIATANumber($iATANumber)
            ->setStatus($status)
            ->setAgentUsername($agentUsername)
            ->setAgentFirstName($agentFirstName)
            ->setAgentLastName($agentLastName)
            ->setAgentAddress1($agentAddress1)
            ->setAgentAddress2($agentAddress2)
            ->setAgentCity($agentCity)
            ->setAgentState($agentState)
            ->setAgentPostalCode($agentPostalCode)
            ->setAgencyCountry($agencyCountry)
            ->setAgentEmail($agentEmail)
            ->setTaContactInfos($taContactInfos)
            ->setActionSuccessful($actionSuccessful)
            ->setExceptions($exceptions);
    }
    /**
     * Get ModifyAgentRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ModifyAgent|null
     */
    public function getModifyAgentRequest()
    {
        return isset($this->ModifyAgentRequest) ? $this->ModifyAgentRequest : null;
    }
    /**
     * Set ModifyAgentRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ModifyAgent $modifyAgentRequest
     * @return \StructType\ModifyAgent
     */
    public function setModifyAgentRequest(\StructType\ModifyAgent $modifyAgentRequest = null)
    {
        if (is_null($modifyAgentRequest) || (is_array($modifyAgentRequest) && empty($modifyAgentRequest))) {
            unset($this->ModifyAgentRequest);
        } else {
            $this->ModifyAgentRequest = $modifyAgentRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ModifyAgent_ActionTypes::valueIsValid()
     * @uses \EnumType\ModifyAgent_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ModifyAgent
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModifyAgent_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ModifyAgent_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\ModifyAgent_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\ModifyAgent
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\ModifyAgent
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AgentUsername value
     * @return string|null
     */
    public function getAgentUsername()
    {
        return $this->AgentUsername;
    }
    /**
     * Set AgentUsername value
     * @param string $agentUsername
     * @return \StructType\ModifyAgent
     */
    public function setAgentUsername($agentUsername = null)
    {
        // validation for constraint: string
        if (!is_null($agentUsername) && !is_string($agentUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentUsername, true), gettype($agentUsername)), __LINE__);
        }
        $this->AgentUsername = $agentUsername;
        return $this;
    }
    /**
     * Get AgentFirstName value
     * @return string|null
     */
    public function getAgentFirstName()
    {
        return $this->AgentFirstName;
    }
    /**
     * Set AgentFirstName value
     * @param string $agentFirstName
     * @return \StructType\ModifyAgent
     */
    public function setAgentFirstName($agentFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($agentFirstName) && !is_string($agentFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentFirstName, true), gettype($agentFirstName)), __LINE__);
        }
        $this->AgentFirstName = $agentFirstName;
        return $this;
    }
    /**
     * Get AgentLastName value
     * @return string|null
     */
    public function getAgentLastName()
    {
        return $this->AgentLastName;
    }
    /**
     * Set AgentLastName value
     * @param string $agentLastName
     * @return \StructType\ModifyAgent
     */
    public function setAgentLastName($agentLastName = null)
    {
        // validation for constraint: string
        if (!is_null($agentLastName) && !is_string($agentLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentLastName, true), gettype($agentLastName)), __LINE__);
        }
        $this->AgentLastName = $agentLastName;
        return $this;
    }
    /**
     * Get AgentAddress1 value
     * @return string|null
     */
    public function getAgentAddress1()
    {
        return $this->AgentAddress1;
    }
    /**
     * Set AgentAddress1 value
     * @param string $agentAddress1
     * @return \StructType\ModifyAgent
     */
    public function setAgentAddress1($agentAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($agentAddress1) && !is_string($agentAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentAddress1, true), gettype($agentAddress1)), __LINE__);
        }
        $this->AgentAddress1 = $agentAddress1;
        return $this;
    }
    /**
     * Get AgentAddress2 value
     * @return string|null
     */
    public function getAgentAddress2()
    {
        return $this->AgentAddress2;
    }
    /**
     * Set AgentAddress2 value
     * @param string $agentAddress2
     * @return \StructType\ModifyAgent
     */
    public function setAgentAddress2($agentAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($agentAddress2) && !is_string($agentAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentAddress2, true), gettype($agentAddress2)), __LINE__);
        }
        $this->AgentAddress2 = $agentAddress2;
        return $this;
    }
    /**
     * Get AgentCity value
     * @return string|null
     */
    public function getAgentCity()
    {
        return $this->AgentCity;
    }
    /**
     * Set AgentCity value
     * @param string $agentCity
     * @return \StructType\ModifyAgent
     */
    public function setAgentCity($agentCity = null)
    {
        // validation for constraint: string
        if (!is_null($agentCity) && !is_string($agentCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentCity, true), gettype($agentCity)), __LINE__);
        }
        $this->AgentCity = $agentCity;
        return $this;
    }
    /**
     * Get AgentState value
     * @return string|null
     */
    public function getAgentState()
    {
        return $this->AgentState;
    }
    /**
     * Set AgentState value
     * @param string $agentState
     * @return \StructType\ModifyAgent
     */
    public function setAgentState($agentState = null)
    {
        // validation for constraint: string
        if (!is_null($agentState) && !is_string($agentState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentState, true), gettype($agentState)), __LINE__);
        }
        $this->AgentState = $agentState;
        return $this;
    }
    /**
     * Get AgentPostalCode value
     * @return string|null
     */
    public function getAgentPostalCode()
    {
        return $this->AgentPostalCode;
    }
    /**
     * Set AgentPostalCode value
     * @param string $agentPostalCode
     * @return \StructType\ModifyAgent
     */
    public function setAgentPostalCode($agentPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentPostalCode) && !is_string($agentPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentPostalCode, true), gettype($agentPostalCode)), __LINE__);
        }
        $this->AgentPostalCode = $agentPostalCode;
        return $this;
    }
    /**
     * Get AgencyCountry value
     * @return string|null
     */
    public function getAgencyCountry()
    {
        return $this->AgencyCountry;
    }
    /**
     * Set AgencyCountry value
     * @param string $agencyCountry
     * @return \StructType\ModifyAgent
     */
    public function setAgencyCountry($agencyCountry = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCountry) && !is_string($agencyCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCountry, true), gettype($agencyCountry)), __LINE__);
        }
        $this->AgencyCountry = $agencyCountry;
        return $this;
    }
    /**
     * Get AgentEmail value
     * @return string|null
     */
    public function getAgentEmail()
    {
        return $this->AgentEmail;
    }
    /**
     * Set AgentEmail value
     * @param string $agentEmail
     * @return \StructType\ModifyAgent
     */
    public function setAgentEmail($agentEmail = null)
    {
        // validation for constraint: string
        if (!is_null($agentEmail) && !is_string($agentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentEmail, true), gettype($agentEmail)), __LINE__);
        }
        $this->AgentEmail = $agentEmail;
        return $this;
    }
    /**
     * Get TaContactInfos value
     * @return \ArrayType\ArrayOfTAContactInfo|null
     */
    public function getTaContactInfos()
    {
        return $this->TaContactInfos;
    }
    /**
     * Set TaContactInfos value
     * @param \ArrayType\ArrayOfTAContactInfo $taContactInfos
     * @return \StructType\ModifyAgent
     */
    public function setTaContactInfos(\ArrayType\ArrayOfTAContactInfo $taContactInfos = null)
    {
        $this->TaContactInfos = $taContactInfos;
        return $this;
    }
    /**
     * Get ActionSuccessful value
     * @return bool|null
     */
    public function getActionSuccessful()
    {
        return $this->ActionSuccessful;
    }
    /**
     * Set ActionSuccessful value
     * @param bool $actionSuccessful
     * @return \StructType\ModifyAgent
     */
    public function setActionSuccessful($actionSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($actionSuccessful) && !is_bool($actionSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actionSuccessful, true), gettype($actionSuccessful)), __LINE__);
        }
        $this->ActionSuccessful = $actionSuccessful;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ModifyAgent
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
