<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginTravelAgent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginTravelAgent
 * @subpackage Structs
 */
class LoginTravelAgent extends TransactionInfo
{
    /**
     * The LoginTravelAgentRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LoginTravelAgent
     */
    public $LoginTravelAgentRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * Constructor method for LoginTravelAgent
     * @uses LoginTravelAgent::setLoginTravelAgentRequest()
     * @uses LoginTravelAgent::setIATANumber()
     * @uses LoginTravelAgent::setUserName()
     * @uses LoginTravelAgent::setPassword()
     * @param \StructType\LoginTravelAgent $loginTravelAgentRequest
     * @param string $iATANumber
     * @param string $userName
     * @param string $password
     */
    public function __construct(\StructType\LoginTravelAgent $loginTravelAgentRequest = null, $iATANumber = null, $userName = null, $password = null)
    {
        $this
            ->setLoginTravelAgentRequest($loginTravelAgentRequest)
            ->setIATANumber($iATANumber)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get LoginTravelAgentRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LoginTravelAgent|null
     */
    public function getLoginTravelAgentRequest()
    {
        return isset($this->LoginTravelAgentRequest) ? $this->LoginTravelAgentRequest : null;
    }
    /**
     * Set LoginTravelAgentRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LoginTravelAgent $loginTravelAgentRequest
     * @return \StructType\LoginTravelAgent
     */
    public function setLoginTravelAgentRequest(\StructType\LoginTravelAgent $loginTravelAgentRequest = null)
    {
        if (is_null($loginTravelAgentRequest) || (is_array($loginTravelAgentRequest) && empty($loginTravelAgentRequest))) {
            unset($this->LoginTravelAgentRequest);
        } else {
            $this->LoginTravelAgentRequest = $loginTravelAgentRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\LoginTravelAgent
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\LoginTravelAgent
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\LoginTravelAgent
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
