<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAgency StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateAgency
 * @subpackage Structs
 */
class CreateAgency extends TransactionInfo
{
    /**
     * The createAgencyRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreateAgency
     */
    public $createAgencyRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The AgencyAdress1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyAdress1;
    /**
     * The AgencyAdress2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyAdress2;
    /**
     * The AgencyCity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyCity;
    /**
     * The AgencyState
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyState;
    /**
     * The AgencyCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyCurrency;
    /**
     * The LegalName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LegalName;
    /**
     * The AgencyPostalCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyPostalCode;
    /**
     * The AgencyCountry
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyCountry;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContactName;
    /**
     * The AccountFirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountFirstName;
    /**
     * The AccountLastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountLastName;
    /**
     * The AccountEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountEmail;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfTAContactInfo
     */
    public $ContactInfos;
    /**
     * The NumberOfBranches
     * @var int
     */
    public $NumberOfBranches;
    /**
     * The AgencyWebSiteUrl
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyWebSiteUrl;
    /**
     * The AgencyCreditLimit
     * @var int
     */
    public $AgencyCreditLimit;
    /**
     * The AgencyCreditLimitCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyCreditLimitCurrency;
    /**
     * The AgencyFetExempt
     * @var bool
     */
    public $AgencyFetExempt;
    /**
     * The PreferrEmailReceipt
     * @var bool
     */
    public $PreferrEmailReceipt;
    /**
     * The PreferrFaxReceipt
     * @var bool
     */
    public $PreferrFaxReceipt;
    /**
     * The PreferrMailReceipt
     * @var bool
     */
    public $PreferrMailReceipt;
    /**
     * The AgencyType
     * @var string
     */
    public $AgencyType;
    /**
     * The AccountUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountUserName;
    /**
     * The AgencyRegion
     * @var int
     */
    public $AgencyRegion;
    /**
     * The UseParentCreditLimit
     * @var bool
     */
    public $UseParentCreditLimit;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LanguageCode;
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountID;
    /**
     * The ActionSuccessful
     * @var bool
     */
    public $ActionSuccessful;
    /**
     * The AgencyStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AgencyStatus;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for CreateAgency
     * @uses CreateAgency::setCreateAgencyRequest()
     * @uses CreateAgency::setActionType()
     * @uses CreateAgency::setIATANumber()
     * @uses CreateAgency::setAgencyName()
     * @uses CreateAgency::setAgencyAdress1()
     * @uses CreateAgency::setAgencyAdress2()
     * @uses CreateAgency::setAgencyCity()
     * @uses CreateAgency::setAgencyState()
     * @uses CreateAgency::setAgencyCurrency()
     * @uses CreateAgency::setLegalName()
     * @uses CreateAgency::setAgencyPostalCode()
     * @uses CreateAgency::setAgencyCountry()
     * @uses CreateAgency::setContactName()
     * @uses CreateAgency::setAccountFirstName()
     * @uses CreateAgency::setAccountLastName()
     * @uses CreateAgency::setAccountEmail()
     * @uses CreateAgency::setContactInfos()
     * @uses CreateAgency::setNumberOfBranches()
     * @uses CreateAgency::setAgencyWebSiteUrl()
     * @uses CreateAgency::setAgencyCreditLimit()
     * @uses CreateAgency::setAgencyCreditLimitCurrency()
     * @uses CreateAgency::setAgencyFetExempt()
     * @uses CreateAgency::setPreferrEmailReceipt()
     * @uses CreateAgency::setPreferrFaxReceipt()
     * @uses CreateAgency::setPreferrMailReceipt()
     * @uses CreateAgency::setAgencyType()
     * @uses CreateAgency::setAccountUserName()
     * @uses CreateAgency::setAgencyRegion()
     * @uses CreateAgency::setUseParentCreditLimit()
     * @uses CreateAgency::setLanguageCode()
     * @uses CreateAgency::setAccountID()
     * @uses CreateAgency::setActionSuccessful()
     * @uses CreateAgency::setAgencyStatus()
     * @uses CreateAgency::setExceptions()
     * @param \StructType\CreateAgency $createAgencyRequest
     * @param string $actionType
     * @param string $iATANumber
     * @param string $agencyName
     * @param string $agencyAdress1
     * @param string $agencyAdress2
     * @param string $agencyCity
     * @param string $agencyState
     * @param string $agencyCurrency
     * @param string $legalName
     * @param string $agencyPostalCode
     * @param string $agencyCountry
     * @param string $contactName
     * @param string $accountFirstName
     * @param string $accountLastName
     * @param string $accountEmail
     * @param \ArrayType\ArrayOfTAContactInfo $contactInfos
     * @param int $numberOfBranches
     * @param string $agencyWebSiteUrl
     * @param int $agencyCreditLimit
     * @param string $agencyCreditLimitCurrency
     * @param bool $agencyFetExempt
     * @param bool $preferrEmailReceipt
     * @param bool $preferrFaxReceipt
     * @param bool $preferrMailReceipt
     * @param string $agencyType
     * @param string $accountUserName
     * @param int $agencyRegion
     * @param bool $useParentCreditLimit
     * @param string $languageCode
     * @param string $accountID
     * @param bool $actionSuccessful
     * @param string $agencyStatus
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\CreateAgency $createAgencyRequest = null, $actionType = null, $iATANumber = null, $agencyName = null, $agencyAdress1 = null, $agencyAdress2 = null, $agencyCity = null, $agencyState = null, $agencyCurrency = null, $legalName = null, $agencyPostalCode = null, $agencyCountry = null, $contactName = null, $accountFirstName = null, $accountLastName = null, $accountEmail = null, \ArrayType\ArrayOfTAContactInfo $contactInfos = null, $numberOfBranches = null, $agencyWebSiteUrl = null, $agencyCreditLimit = null, $agencyCreditLimitCurrency = null, $agencyFetExempt = null, $preferrEmailReceipt = null, $preferrFaxReceipt = null, $preferrMailReceipt = null, $agencyType = null, $accountUserName = null, $agencyRegion = null, $useParentCreditLimit = null, $languageCode = null, $accountID = null, $actionSuccessful = null, $agencyStatus = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setCreateAgencyRequest($createAgencyRequest)
            ->setActionType($actionType)
            ->setIATANumber($iATANumber)
            ->setAgencyName($agencyName)
            ->setAgencyAdress1($agencyAdress1)
            ->setAgencyAdress2($agencyAdress2)
            ->setAgencyCity($agencyCity)
            ->setAgencyState($agencyState)
            ->setAgencyCurrency($agencyCurrency)
            ->setLegalName($legalName)
            ->setAgencyPostalCode($agencyPostalCode)
            ->setAgencyCountry($agencyCountry)
            ->setContactName($contactName)
            ->setAccountFirstName($accountFirstName)
            ->setAccountLastName($accountLastName)
            ->setAccountEmail($accountEmail)
            ->setContactInfos($contactInfos)
            ->setNumberOfBranches($numberOfBranches)
            ->setAgencyWebSiteUrl($agencyWebSiteUrl)
            ->setAgencyCreditLimit($agencyCreditLimit)
            ->setAgencyCreditLimitCurrency($agencyCreditLimitCurrency)
            ->setAgencyFetExempt($agencyFetExempt)
            ->setPreferrEmailReceipt($preferrEmailReceipt)
            ->setPreferrFaxReceipt($preferrFaxReceipt)
            ->setPreferrMailReceipt($preferrMailReceipt)
            ->setAgencyType($agencyType)
            ->setAccountUserName($accountUserName)
            ->setAgencyRegion($agencyRegion)
            ->setUseParentCreditLimit($useParentCreditLimit)
            ->setLanguageCode($languageCode)
            ->setAccountID($accountID)
            ->setActionSuccessful($actionSuccessful)
            ->setAgencyStatus($agencyStatus)
            ->setExceptions($exceptions);
    }
    /**
     * Get createAgencyRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreateAgency|null
     */
    public function getCreateAgencyRequest()
    {
        return isset($this->createAgencyRequest) ? $this->createAgencyRequest : null;
    }
    /**
     * Set createAgencyRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreateAgency $createAgencyRequest
     * @return \StructType\CreateAgency
     */
    public function setCreateAgencyRequest(\StructType\CreateAgency $createAgencyRequest = null)
    {
        if (is_null($createAgencyRequest) || (is_array($createAgencyRequest) && empty($createAgencyRequest))) {
            unset($this->createAgencyRequest);
        } else {
            $this->createAgencyRequest = $createAgencyRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\CreateAgency_ActionTypes::valueIsValid()
     * @uses \EnumType\CreateAgency_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\CreateAgency
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreateAgency_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreateAgency_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\CreateAgency_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\CreateAgency
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\CreateAgency
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Get AgencyAdress1 value
     * @return string|null
     */
    public function getAgencyAdress1()
    {
        return $this->AgencyAdress1;
    }
    /**
     * Set AgencyAdress1 value
     * @param string $agencyAdress1
     * @return \StructType\CreateAgency
     */
    public function setAgencyAdress1($agencyAdress1 = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAdress1) && !is_string($agencyAdress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAdress1, true), gettype($agencyAdress1)), __LINE__);
        }
        $this->AgencyAdress1 = $agencyAdress1;
        return $this;
    }
    /**
     * Get AgencyAdress2 value
     * @return string|null
     */
    public function getAgencyAdress2()
    {
        return $this->AgencyAdress2;
    }
    /**
     * Set AgencyAdress2 value
     * @param string $agencyAdress2
     * @return \StructType\CreateAgency
     */
    public function setAgencyAdress2($agencyAdress2 = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAdress2) && !is_string($agencyAdress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAdress2, true), gettype($agencyAdress2)), __LINE__);
        }
        $this->AgencyAdress2 = $agencyAdress2;
        return $this;
    }
    /**
     * Get AgencyCity value
     * @return string|null
     */
    public function getAgencyCity()
    {
        return $this->AgencyCity;
    }
    /**
     * Set AgencyCity value
     * @param string $agencyCity
     * @return \StructType\CreateAgency
     */
    public function setAgencyCity($agencyCity = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCity) && !is_string($agencyCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCity, true), gettype($agencyCity)), __LINE__);
        }
        $this->AgencyCity = $agencyCity;
        return $this;
    }
    /**
     * Get AgencyState value
     * @return string|null
     */
    public function getAgencyState()
    {
        return $this->AgencyState;
    }
    /**
     * Set AgencyState value
     * @param string $agencyState
     * @return \StructType\CreateAgency
     */
    public function setAgencyState($agencyState = null)
    {
        // validation for constraint: string
        if (!is_null($agencyState) && !is_string($agencyState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyState, true), gettype($agencyState)), __LINE__);
        }
        $this->AgencyState = $agencyState;
        return $this;
    }
    /**
     * Get AgencyCurrency value
     * @return string|null
     */
    public function getAgencyCurrency()
    {
        return $this->AgencyCurrency;
    }
    /**
     * Set AgencyCurrency value
     * @param string $agencyCurrency
     * @return \StructType\CreateAgency
     */
    public function setAgencyCurrency($agencyCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCurrency) && !is_string($agencyCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCurrency, true), gettype($agencyCurrency)), __LINE__);
        }
        $this->AgencyCurrency = $agencyCurrency;
        return $this;
    }
    /**
     * Get LegalName value
     * @return string|null
     */
    public function getLegalName()
    {
        return $this->LegalName;
    }
    /**
     * Set LegalName value
     * @param string $legalName
     * @return \StructType\CreateAgency
     */
    public function setLegalName($legalName = null)
    {
        // validation for constraint: string
        if (!is_null($legalName) && !is_string($legalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalName, true), gettype($legalName)), __LINE__);
        }
        $this->LegalName = $legalName;
        return $this;
    }
    /**
     * Get AgencyPostalCode value
     * @return string|null
     */
    public function getAgencyPostalCode()
    {
        return $this->AgencyPostalCode;
    }
    /**
     * Set AgencyPostalCode value
     * @param string $agencyPostalCode
     * @return \StructType\CreateAgency
     */
    public function setAgencyPostalCode($agencyPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($agencyPostalCode) && !is_string($agencyPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyPostalCode, true), gettype($agencyPostalCode)), __LINE__);
        }
        $this->AgencyPostalCode = $agencyPostalCode;
        return $this;
    }
    /**
     * Get AgencyCountry value
     * @return string|null
     */
    public function getAgencyCountry()
    {
        return $this->AgencyCountry;
    }
    /**
     * Set AgencyCountry value
     * @param string $agencyCountry
     * @return \StructType\CreateAgency
     */
    public function setAgencyCountry($agencyCountry = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCountry) && !is_string($agencyCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCountry, true), gettype($agencyCountry)), __LINE__);
        }
        $this->AgencyCountry = $agencyCountry;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\CreateAgency
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get AccountFirstName value
     * @return string|null
     */
    public function getAccountFirstName()
    {
        return $this->AccountFirstName;
    }
    /**
     * Set AccountFirstName value
     * @param string $accountFirstName
     * @return \StructType\CreateAgency
     */
    public function setAccountFirstName($accountFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($accountFirstName) && !is_string($accountFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountFirstName, true), gettype($accountFirstName)), __LINE__);
        }
        $this->AccountFirstName = $accountFirstName;
        return $this;
    }
    /**
     * Get AccountLastName value
     * @return string|null
     */
    public function getAccountLastName()
    {
        return $this->AccountLastName;
    }
    /**
     * Set AccountLastName value
     * @param string $accountLastName
     * @return \StructType\CreateAgency
     */
    public function setAccountLastName($accountLastName = null)
    {
        // validation for constraint: string
        if (!is_null($accountLastName) && !is_string($accountLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountLastName, true), gettype($accountLastName)), __LINE__);
        }
        $this->AccountLastName = $accountLastName;
        return $this;
    }
    /**
     * Get AccountEmail value
     * @return string|null
     */
    public function getAccountEmail()
    {
        return $this->AccountEmail;
    }
    /**
     * Set AccountEmail value
     * @param string $accountEmail
     * @return \StructType\CreateAgency
     */
    public function setAccountEmail($accountEmail = null)
    {
        // validation for constraint: string
        if (!is_null($accountEmail) && !is_string($accountEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountEmail, true), gettype($accountEmail)), __LINE__);
        }
        $this->AccountEmail = $accountEmail;
        return $this;
    }
    /**
     * Get ContactInfos value
     * @return \ArrayType\ArrayOfTAContactInfo|null
     */
    public function getContactInfos()
    {
        return $this->ContactInfos;
    }
    /**
     * Set ContactInfos value
     * @param \ArrayType\ArrayOfTAContactInfo $contactInfos
     * @return \StructType\CreateAgency
     */
    public function setContactInfos(\ArrayType\ArrayOfTAContactInfo $contactInfos = null)
    {
        $this->ContactInfos = $contactInfos;
        return $this;
    }
    /**
     * Get NumberOfBranches value
     * @return int|null
     */
    public function getNumberOfBranches()
    {
        return $this->NumberOfBranches;
    }
    /**
     * Set NumberOfBranches value
     * @param int $numberOfBranches
     * @return \StructType\CreateAgency
     */
    public function setNumberOfBranches($numberOfBranches = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBranches) && !(is_int($numberOfBranches) || ctype_digit($numberOfBranches))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBranches, true), gettype($numberOfBranches)), __LINE__);
        }
        $this->NumberOfBranches = $numberOfBranches;
        return $this;
    }
    /**
     * Get AgencyWebSiteUrl value
     * @return string|null
     */
    public function getAgencyWebSiteUrl()
    {
        return $this->AgencyWebSiteUrl;
    }
    /**
     * Set AgencyWebSiteUrl value
     * @param string $agencyWebSiteUrl
     * @return \StructType\CreateAgency
     */
    public function setAgencyWebSiteUrl($agencyWebSiteUrl = null)
    {
        // validation for constraint: string
        if (!is_null($agencyWebSiteUrl) && !is_string($agencyWebSiteUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyWebSiteUrl, true), gettype($agencyWebSiteUrl)), __LINE__);
        }
        $this->AgencyWebSiteUrl = $agencyWebSiteUrl;
        return $this;
    }
    /**
     * Get AgencyCreditLimit value
     * @return int|null
     */
    public function getAgencyCreditLimit()
    {
        return $this->AgencyCreditLimit;
    }
    /**
     * Set AgencyCreditLimit value
     * @param int $agencyCreditLimit
     * @return \StructType\CreateAgency
     */
    public function setAgencyCreditLimit($agencyCreditLimit = null)
    {
        // validation for constraint: int
        if (!is_null($agencyCreditLimit) && !(is_int($agencyCreditLimit) || ctype_digit($agencyCreditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyCreditLimit, true), gettype($agencyCreditLimit)), __LINE__);
        }
        $this->AgencyCreditLimit = $agencyCreditLimit;
        return $this;
    }
    /**
     * Get AgencyCreditLimitCurrency value
     * @return string|null
     */
    public function getAgencyCreditLimitCurrency()
    {
        return $this->AgencyCreditLimitCurrency;
    }
    /**
     * Set AgencyCreditLimitCurrency value
     * @param string $agencyCreditLimitCurrency
     * @return \StructType\CreateAgency
     */
    public function setAgencyCreditLimitCurrency($agencyCreditLimitCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCreditLimitCurrency) && !is_string($agencyCreditLimitCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCreditLimitCurrency, true), gettype($agencyCreditLimitCurrency)), __LINE__);
        }
        $this->AgencyCreditLimitCurrency = $agencyCreditLimitCurrency;
        return $this;
    }
    /**
     * Get AgencyFetExempt value
     * @return bool|null
     */
    public function getAgencyFetExempt()
    {
        return $this->AgencyFetExempt;
    }
    /**
     * Set AgencyFetExempt value
     * @param bool $agencyFetExempt
     * @return \StructType\CreateAgency
     */
    public function setAgencyFetExempt($agencyFetExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($agencyFetExempt) && !is_bool($agencyFetExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($agencyFetExempt, true), gettype($agencyFetExempt)), __LINE__);
        }
        $this->AgencyFetExempt = $agencyFetExempt;
        return $this;
    }
    /**
     * Get PreferrEmailReceipt value
     * @return bool|null
     */
    public function getPreferrEmailReceipt()
    {
        return $this->PreferrEmailReceipt;
    }
    /**
     * Set PreferrEmailReceipt value
     * @param bool $preferrEmailReceipt
     * @return \StructType\CreateAgency
     */
    public function setPreferrEmailReceipt($preferrEmailReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferrEmailReceipt) && !is_bool($preferrEmailReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferrEmailReceipt, true), gettype($preferrEmailReceipt)), __LINE__);
        }
        $this->PreferrEmailReceipt = $preferrEmailReceipt;
        return $this;
    }
    /**
     * Get PreferrFaxReceipt value
     * @return bool|null
     */
    public function getPreferrFaxReceipt()
    {
        return $this->PreferrFaxReceipt;
    }
    /**
     * Set PreferrFaxReceipt value
     * @param bool $preferrFaxReceipt
     * @return \StructType\CreateAgency
     */
    public function setPreferrFaxReceipt($preferrFaxReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferrFaxReceipt) && !is_bool($preferrFaxReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferrFaxReceipt, true), gettype($preferrFaxReceipt)), __LINE__);
        }
        $this->PreferrFaxReceipt = $preferrFaxReceipt;
        return $this;
    }
    /**
     * Get PreferrMailReceipt value
     * @return bool|null
     */
    public function getPreferrMailReceipt()
    {
        return $this->PreferrMailReceipt;
    }
    /**
     * Set PreferrMailReceipt value
     * @param bool $preferrMailReceipt
     * @return \StructType\CreateAgency
     */
    public function setPreferrMailReceipt($preferrMailReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferrMailReceipt) && !is_bool($preferrMailReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferrMailReceipt, true), gettype($preferrMailReceipt)), __LINE__);
        }
        $this->PreferrMailReceipt = $preferrMailReceipt;
        return $this;
    }
    /**
     * Get AgencyType value
     * @return string|null
     */
    public function getAgencyType()
    {
        return $this->AgencyType;
    }
    /**
     * Set AgencyType value
     * @uses \EnumType\Enumerations_TravelAgencyTypes::valueIsValid()
     * @uses \EnumType\Enumerations_TravelAgencyTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $agencyType
     * @return \StructType\CreateAgency
     */
    public function setAgencyType($agencyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_TravelAgencyTypes::valueIsValid($agencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_TravelAgencyTypes', is_array($agencyType) ? implode(', ', $agencyType) : var_export($agencyType, true), implode(', ', \EnumType\Enumerations_TravelAgencyTypes::getValidValues())), __LINE__);
        }
        $this->AgencyType = $agencyType;
        return $this;
    }
    /**
     * Get AccountUserName value
     * @return string|null
     */
    public function getAccountUserName()
    {
        return $this->AccountUserName;
    }
    /**
     * Set AccountUserName value
     * @param string $accountUserName
     * @return \StructType\CreateAgency
     */
    public function setAccountUserName($accountUserName = null)
    {
        // validation for constraint: string
        if (!is_null($accountUserName) && !is_string($accountUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountUserName, true), gettype($accountUserName)), __LINE__);
        }
        $this->AccountUserName = $accountUserName;
        return $this;
    }
    /**
     * Get AgencyRegion value
     * @return int|null
     */
    public function getAgencyRegion()
    {
        return $this->AgencyRegion;
    }
    /**
     * Set AgencyRegion value
     * @param int $agencyRegion
     * @return \StructType\CreateAgency
     */
    public function setAgencyRegion($agencyRegion = null)
    {
        // validation for constraint: int
        if (!is_null($agencyRegion) && !(is_int($agencyRegion) || ctype_digit($agencyRegion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyRegion, true), gettype($agencyRegion)), __LINE__);
        }
        $this->AgencyRegion = $agencyRegion;
        return $this;
    }
    /**
     * Get UseParentCreditLimit value
     * @return bool|null
     */
    public function getUseParentCreditLimit()
    {
        return $this->UseParentCreditLimit;
    }
    /**
     * Set UseParentCreditLimit value
     * @param bool $useParentCreditLimit
     * @return \StructType\CreateAgency
     */
    public function setUseParentCreditLimit($useParentCreditLimit = null)
    {
        // validation for constraint: boolean
        if (!is_null($useParentCreditLimit) && !is_bool($useParentCreditLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useParentCreditLimit, true), gettype($useParentCreditLimit)), __LINE__);
        }
        $this->UseParentCreditLimit = $useParentCreditLimit;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\CreateAgency
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get AccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountID()
    {
        return isset($this->AccountID) ? $this->AccountID : null;
    }
    /**
     * Set AccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountID
     * @return \StructType\CreateAgency
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: string
        if (!is_null($accountID) && !is_string($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        if (is_null($accountID) || (is_array($accountID) && empty($accountID))) {
            unset($this->AccountID);
        } else {
            $this->AccountID = $accountID;
        }
        return $this;
    }
    /**
     * Get ActionSuccessful value
     * @return bool|null
     */
    public function getActionSuccessful()
    {
        return $this->ActionSuccessful;
    }
    /**
     * Set ActionSuccessful value
     * @param bool $actionSuccessful
     * @return \StructType\CreateAgency
     */
    public function setActionSuccessful($actionSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($actionSuccessful) && !is_bool($actionSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actionSuccessful, true), gettype($actionSuccessful)), __LINE__);
        }
        $this->ActionSuccessful = $actionSuccessful;
        return $this;
    }
    /**
     * Get AgencyStatus value
     * @return string|null
     */
    public function getAgencyStatus()
    {
        return $this->AgencyStatus;
    }
    /**
     * Set AgencyStatus value
     * @param string $agencyStatus
     * @return \StructType\CreateAgency
     */
    public function setAgencyStatus($agencyStatus = null)
    {
        // validation for constraint: string
        if (!is_null($agencyStatus) && !is_string($agencyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyStatus, true), gettype($agencyStatus)), __LINE__);
        }
        $this->AgencyStatus = $agencyStatus;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\CreateAgency
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
