<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommissionInfo
 * @subpackage Structs
 */
class CommissionInfo extends AbstractStructBase
{
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookingUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingUserName;
    /**
     * The OriginatingAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginatingAirport;
    /**
     * The DestinationAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DestinationAirport;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The PaymentDate
     * @var string
     */
    public $PaymentDate;
    /**
     * The PaymentUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentUserName;
    /**
     * The BookingCurrency
     * @var string
     */
    public $BookingCurrency;
    /**
     * The BookingAmount
     * @var float
     */
    public $BookingAmount;
    /**
     * The PaymentCurrency
     * @var string
     */
    public $PaymentCurrency;
    /**
     * The PaymentAmount
     * @var float
     */
    public $PaymentAmount;
    /**
     * The AgencyCommission
     * @var float
     */
    public $AgencyCommission;
    /**
     * The PassengerCount
     * @var int
     */
    public $PassengerCount;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TransactionNumber;
    /**
     * Constructor method for CommissionInfo
     * @uses CommissionInfo::setConfirmationNumber()
     * @uses CommissionInfo::setBookingUserName()
     * @uses CommissionInfo::setOriginatingAirport()
     * @uses CommissionInfo::setDestinationAirport()
     * @uses CommissionInfo::setIATANumber()
     * @uses CommissionInfo::setPaymentDate()
     * @uses CommissionInfo::setPaymentUserName()
     * @uses CommissionInfo::setBookingCurrency()
     * @uses CommissionInfo::setBookingAmount()
     * @uses CommissionInfo::setPaymentCurrency()
     * @uses CommissionInfo::setPaymentAmount()
     * @uses CommissionInfo::setAgencyCommission()
     * @uses CommissionInfo::setPassengerCount()
     * @uses CommissionInfo::setTransactionNumber()
     * @param string $confirmationNumber
     * @param string $bookingUserName
     * @param string $originatingAirport
     * @param string $destinationAirport
     * @param string $iATANumber
     * @param string $paymentDate
     * @param string $paymentUserName
     * @param string $bookingCurrency
     * @param float $bookingAmount
     * @param string $paymentCurrency
     * @param float $paymentAmount
     * @param float $agencyCommission
     * @param int $passengerCount
     * @param string $transactionNumber
     */
    public function __construct($confirmationNumber = null, $bookingUserName = null, $originatingAirport = null, $destinationAirport = null, $iATANumber = null, $paymentDate = null, $paymentUserName = null, $bookingCurrency = null, $bookingAmount = null, $paymentCurrency = null, $paymentAmount = null, $agencyCommission = null, $passengerCount = null, $transactionNumber = null)
    {
        $this
            ->setConfirmationNumber($confirmationNumber)
            ->setBookingUserName($bookingUserName)
            ->setOriginatingAirport($originatingAirport)
            ->setDestinationAirport($destinationAirport)
            ->setIATANumber($iATANumber)
            ->setPaymentDate($paymentDate)
            ->setPaymentUserName($paymentUserName)
            ->setBookingCurrency($bookingCurrency)
            ->setBookingAmount($bookingAmount)
            ->setPaymentCurrency($paymentCurrency)
            ->setPaymentAmount($paymentAmount)
            ->setAgencyCommission($agencyCommission)
            ->setPassengerCount($passengerCount)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\CommissionInfo
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get BookingUserName value
     * @return string|null
     */
    public function getBookingUserName()
    {
        return $this->BookingUserName;
    }
    /**
     * Set BookingUserName value
     * @param string $bookingUserName
     * @return \StructType\CommissionInfo
     */
    public function setBookingUserName($bookingUserName = null)
    {
        // validation for constraint: string
        if (!is_null($bookingUserName) && !is_string($bookingUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingUserName, true), gettype($bookingUserName)), __LINE__);
        }
        $this->BookingUserName = $bookingUserName;
        return $this;
    }
    /**
     * Get OriginatingAirport value
     * @return string|null
     */
    public function getOriginatingAirport()
    {
        return $this->OriginatingAirport;
    }
    /**
     * Set OriginatingAirport value
     * @param string $originatingAirport
     * @return \StructType\CommissionInfo
     */
    public function setOriginatingAirport($originatingAirport = null)
    {
        // validation for constraint: string
        if (!is_null($originatingAirport) && !is_string($originatingAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatingAirport, true), gettype($originatingAirport)), __LINE__);
        }
        $this->OriginatingAirport = $originatingAirport;
        return $this;
    }
    /**
     * Get DestinationAirport value
     * @return string|null
     */
    public function getDestinationAirport()
    {
        return $this->DestinationAirport;
    }
    /**
     * Set DestinationAirport value
     * @param string $destinationAirport
     * @return \StructType\CommissionInfo
     */
    public function setDestinationAirport($destinationAirport = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirport) && !is_string($destinationAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirport, true), gettype($destinationAirport)), __LINE__);
        }
        $this->DestinationAirport = $destinationAirport;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\CommissionInfo
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\CommissionInfo
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get PaymentUserName value
     * @return string|null
     */
    public function getPaymentUserName()
    {
        return $this->PaymentUserName;
    }
    /**
     * Set PaymentUserName value
     * @param string $paymentUserName
     * @return \StructType\CommissionInfo
     */
    public function setPaymentUserName($paymentUserName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentUserName) && !is_string($paymentUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentUserName, true), gettype($paymentUserName)), __LINE__);
        }
        $this->PaymentUserName = $paymentUserName;
        return $this;
    }
    /**
     * Get BookingCurrency value
     * @return string|null
     */
    public function getBookingCurrency()
    {
        return $this->BookingCurrency;
    }
    /**
     * Set BookingCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingCurrency
     * @return \StructType\CommissionInfo
     */
    public function setBookingCurrency($bookingCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($bookingCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($bookingCurrency) ? implode(', ', $bookingCurrency) : var_export($bookingCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->BookingCurrency = $bookingCurrency;
        return $this;
    }
    /**
     * Get BookingAmount value
     * @return float|null
     */
    public function getBookingAmount()
    {
        return $this->BookingAmount;
    }
    /**
     * Set BookingAmount value
     * @param float $bookingAmount
     * @return \StructType\CommissionInfo
     */
    public function setBookingAmount($bookingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bookingAmount) && !(is_float($bookingAmount) || is_numeric($bookingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingAmount, true), gettype($bookingAmount)), __LINE__);
        }
        $this->BookingAmount = $bookingAmount;
        return $this;
    }
    /**
     * Get PaymentCurrency value
     * @return string|null
     */
    public function getPaymentCurrency()
    {
        return $this->PaymentCurrency;
    }
    /**
     * Set PaymentCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentCurrency
     * @return \StructType\CommissionInfo
     */
    public function setPaymentCurrency($paymentCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($paymentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($paymentCurrency) ? implode(', ', $paymentCurrency) : var_export($paymentCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->PaymentCurrency = $paymentCurrency;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\CommissionInfo
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get AgencyCommission value
     * @return float|null
     */
    public function getAgencyCommission()
    {
        return $this->AgencyCommission;
    }
    /**
     * Set AgencyCommission value
     * @param float $agencyCommission
     * @return \StructType\CommissionInfo
     */
    public function setAgencyCommission($agencyCommission = null)
    {
        // validation for constraint: float
        if (!is_null($agencyCommission) && !(is_float($agencyCommission) || is_numeric($agencyCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agencyCommission, true), gettype($agencyCommission)), __LINE__);
        }
        $this->AgencyCommission = $agencyCommission;
        return $this;
    }
    /**
     * Get PassengerCount value
     * @return int|null
     */
    public function getPassengerCount()
    {
        return $this->PassengerCount;
    }
    /**
     * Set PassengerCount value
     * @param int $passengerCount
     * @return \StructType\CommissionInfo
     */
    public function setPassengerCount($passengerCount = null)
    {
        // validation for constraint: int
        if (!is_null($passengerCount) && !(is_int($passengerCount) || ctype_digit($passengerCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerCount, true), gettype($passengerCount)), __LINE__);
        }
        $this->PassengerCount = $passengerCount;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param string $transactionNumber
     * @return \StructType\CommissionInfo
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
}
