<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociateToReservation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AssociateToReservation
 * @subpackage Structs
 */
class AssociateToReservation extends TransactionInfo
{
    /**
     * The AssociateToReservationRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssociateToReservation
     */
    public $AssociateToReservationRequest;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATA;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Override;
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * Constructor method for AssociateToReservation
     * @uses AssociateToReservation::setAssociateToReservationRequest()
     * @uses AssociateToReservation::setConfirmationNumber()
     * @uses AssociateToReservation::setIATA()
     * @uses AssociateToReservation::setOverride()
     * @uses AssociateToReservation::setSeriesNumber()
     * @param \StructType\AssociateToReservation $associateToReservationRequest
     * @param string $confirmationNumber
     * @param string $iATA
     * @param string $override
     * @param string $seriesNumber
     */
    public function __construct(\StructType\AssociateToReservation $associateToReservationRequest = null, $confirmationNumber = null, $iATA = null, $override = null, $seriesNumber = null)
    {
        $this
            ->setAssociateToReservationRequest($associateToReservationRequest)
            ->setConfirmationNumber($confirmationNumber)
            ->setIATA($iATA)
            ->setOverride($override)
            ->setSeriesNumber($seriesNumber);
    }
    /**
     * Get AssociateToReservationRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssociateToReservation|null
     */
    public function getAssociateToReservationRequest()
    {
        return isset($this->AssociateToReservationRequest) ? $this->AssociateToReservationRequest : null;
    }
    /**
     * Set AssociateToReservationRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AssociateToReservation $associateToReservationRequest
     * @return \StructType\AssociateToReservation
     */
    public function setAssociateToReservationRequest(\StructType\AssociateToReservation $associateToReservationRequest = null)
    {
        if (is_null($associateToReservationRequest) || (is_array($associateToReservationRequest) && empty($associateToReservationRequest))) {
            unset($this->AssociateToReservationRequest);
        } else {
            $this->AssociateToReservationRequest = $associateToReservationRequest;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \StructType\AssociateToReservation
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get IATA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATA()
    {
        return isset($this->IATA) ? $this->IATA : null;
    }
    /**
     * Set IATA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATA
     * @return \StructType\AssociateToReservation
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        if (is_null($iATA) || (is_array($iATA) && empty($iATA))) {
            unset($this->IATA);
        } else {
            $this->IATA = $iATA;
        }
        return $this;
    }
    /**
     * Get Override value
     * @return string|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @uses \EnumType\Enumerations_AnswerTypes::valueIsValid()
     * @uses \EnumType\Enumerations_AnswerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $override
     * @return \StructType\AssociateToReservation
     */
    public function setOverride($override = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AnswerTypes::valueIsValid($override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AnswerTypes', is_array($override) ? implode(', ', $override) : var_export($override, true), implode(', ', \EnumType\Enumerations_AnswerTypes::getValidValues())), __LINE__);
        }
        $this->Override = $override;
        return $this;
    }
    /**
     * Get SeriesNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return isset($this->SeriesNumber) ? $this->SeriesNumber : null;
    }
    /**
     * Set SeriesNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesNumber
     * @return \StructType\AssociateToReservation
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        if (is_null($seriesNumber) || (is_array($seriesNumber) && empty($seriesNumber))) {
            unset($this->SeriesNumber);
        } else {
            $this->SeriesNumber = $seriesNumber;
        }
        return $this;
    }
}
