<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AgencyPNR
 * @subpackage Structs
 */
class AgencyPNR extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The BookDate
     * @var string
     */
    public $BookDate;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Adress1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Adress1;
    /**
     * The PaymentReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentReferenceNumber;
    /**
     * Constructor method for AgencyPNR
     * @uses AgencyPNR::setSeriesNumber()
     * @uses AgencyPNR::setConfirmationNumber()
     * @uses AgencyPNR::setFirstName()
     * @uses AgencyPNR::setLastName()
     * @uses AgencyPNR::setBookDate()
     * @uses AgencyPNR::setEmail()
     * @uses AgencyPNR::setAdress1()
     * @uses AgencyPNR::setPaymentReferenceNumber()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $firstName
     * @param string $lastName
     * @param string $bookDate
     * @param string $email
     * @param string $adress1
     * @param string $paymentReferenceNumber
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $firstName = null, $lastName = null, $bookDate = null, $email = null, $adress1 = null, $paymentReferenceNumber = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setBookDate($bookDate)
            ->setEmail($email)
            ->setAdress1($adress1)
            ->setPaymentReferenceNumber($paymentReferenceNumber);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\AgencyPNR
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\AgencyPNR
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AgencyPNR
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\AgencyPNR
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get BookDate value
     * @return string|null
     */
    public function getBookDate()
    {
        return $this->BookDate;
    }
    /**
     * Set BookDate value
     * @param string $bookDate
     * @return \StructType\AgencyPNR
     */
    public function setBookDate($bookDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookDate) && !is_string($bookDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookDate, true), gettype($bookDate)), __LINE__);
        }
        $this->BookDate = $bookDate;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\AgencyPNR
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Adress1 value
     * @return string|null
     */
    public function getAdress1()
    {
        return $this->Adress1;
    }
    /**
     * Set Adress1 value
     * @param string $adress1
     * @return \StructType\AgencyPNR
     */
    public function setAdress1($adress1 = null)
    {
        // validation for constraint: string
        if (!is_null($adress1) && !is_string($adress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adress1, true), gettype($adress1)), __LINE__);
        }
        $this->Adress1 = $adress1;
        return $this;
    }
    /**
     * Get PaymentReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentReferenceNumber()
    {
        return isset($this->PaymentReferenceNumber) ? $this->PaymentReferenceNumber : null;
    }
    /**
     * Set PaymentReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentReferenceNumber
     * @return \StructType\AgencyPNR
     */
    public function setPaymentReferenceNumber($paymentReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReferenceNumber) && !is_string($paymentReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentReferenceNumber, true), gettype($paymentReferenceNumber)), __LINE__);
        }
        if (is_null($paymentReferenceNumber) || (is_array($paymentReferenceNumber) && empty($paymentReferenceNumber))) {
            unset($this->PaymentReferenceNumber);
        } else {
            $this->PaymentReferenceNumber = $paymentReferenceNumber;
        }
        return $this;
    }
}
