<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyCreditCardInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AgencyCreditCardInfo
 * @subpackage Structs
 */
class AgencyCreditCardInfo extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountExpirationDate
     * @var string
     */
    public $AccountExpirationDate;
    /**
     * Constructor method for AgencyCreditCardInfo
     * @uses AgencyCreditCardInfo::setAccountNumber()
     * @uses AgencyCreditCardInfo::setAccountName()
     * @uses AgencyCreditCardInfo::setAccountExpirationDate()
     * @param string $accountNumber
     * @param string $accountName
     * @param string $accountExpirationDate
     */
    public function __construct($accountNumber = null, $accountName = null, $accountExpirationDate = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAccountName($accountName)
            ->setAccountExpirationDate($accountExpirationDate);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\AgencyCreditCardInfo
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\AgencyCreditCardInfo
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get AccountExpirationDate value
     * @return string|null
     */
    public function getAccountExpirationDate()
    {
        return $this->AccountExpirationDate;
    }
    /**
     * Set AccountExpirationDate value
     * @param string $accountExpirationDate
     * @return \StructType\AgencyCreditCardInfo
     */
    public function setAccountExpirationDate($accountExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($accountExpirationDate) && !is_string($accountExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountExpirationDate, true), gettype($accountExpirationDate)), __LINE__);
        }
        $this->AccountExpirationDate = $accountExpirationDate;
        return $this;
    }
}
