<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveAgencyDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgencyDetails $parameters
     * @return \StructType\RetrieveAgencyDetailsResponse|bool
     */
    public function RetrieveAgencyDetails(\StructType\RetrieveAgencyDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgencyDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAvailableCredit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAvailableCredit $parameters
     * @return \StructType\RetrieveAvailableCreditResponse|bool
     */
    public function RetrieveAvailableCredit(\StructType\RetrieveAvailableCredit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAvailableCredit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAvailableAgencyCredit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAvailableAgencyCredit $parameters
     * @return \StructType\RetrieveAvailableAgencyCreditResponse|bool
     */
    public function RetrieveAvailableAgencyCredit(\StructType\RetrieveAvailableAgencyCredit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAvailableAgencyCredit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveTravelAgencyPNRList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveTravelAgencyPNRList $parameters
     * @return \StructType\RetrieveTravelAgencyPNRListResponse|bool
     */
    public function RetrieveTravelAgencyPNRList(\StructType\RetrieveTravelAgencyPNRList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveTravelAgencyPNRList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgencyCommission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgencyCommission $parameters
     * @return \StructType\RetrieveAgencyCommissionResponse|bool
     */
    public function RetrieveAgencyCommission(\StructType\RetrieveAgencyCommission $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgencyCommission($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgencyInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgencyInfo $parameters
     * @return \StructType\RetrieveAgencyInfoResponse|bool
     */
    public function RetrieveAgencyInfo(\StructType\RetrieveAgencyInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgencyInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgencyList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgencyList $parameters
     * @return \StructType\RetrieveAgencyListResponse|bool
     */
    public function RetrieveAgencyList(\StructType\RetrieveAgencyList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgencyList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgentList $parameters
     * @return \StructType\RetrieveAgentListResponse|bool
     */
    public function RetrieveAgentList(\StructType\RetrieveAgentList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveDisruptedAgencyPNRList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveDisruptedAgencyPNRList $parameters
     * @return \StructType\RetrieveDisruptedAgencyPNRListResponse|bool
     */
    public function RetrieveDisruptedAgencyPNRList(\StructType\RetrieveDisruptedAgencyPNRList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveDisruptedAgencyPNRList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgencywithCCInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgencywithCCInfo $parameters
     * @return \StructType\RetrieveAgencywithCCInfoResponse|bool
     */
    public function RetrieveAgencywithCCInfo(\StructType\RetrieveAgencywithCCInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgencywithCCInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgentDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgentDetails $parameters
     * @return \StructType\RetrieveAgentDetailsResponse|bool
     */
    public function RetrieveAgentDetails(\StructType\RetrieveAgentDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgentDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveCommissionDashboardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveCommissionDashboardInfo $parameters
     * @return \StructType\RetrieveCommissionDashboardInfoResponse|bool
     */
    public function RetrieveCommissionDashboardInfo(\StructType\RetrieveCommissionDashboardInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveCommissionDashboardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveTransactionDashboardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveTransactionDashboardInfo $parameters
     * @return \StructType\RetrieveTransactionDashboardInfoResponse|bool
     */
    public function RetrieveTransactionDashboardInfo(\StructType\RetrieveTransactionDashboardInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveTransactionDashboardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveBalanceDashboardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveBalanceDashboardInfo $parameters
     * @return \StructType\RetrieveBalanceDashboardInfoResponse|bool
     */
    public function RetrieveBalanceDashboardInfo(\StructType\RetrieveBalanceDashboardInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveBalanceDashboardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveBookingHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveBookingHistory $parameters
     * @return \StructType\RetrieveBookingHistoryResponse|bool
     */
    public function RetrieveBookingHistory(\StructType\RetrieveBookingHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveBookingHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveCumulativeBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveCumulativeBalance $parameters
     * @return \StructType\RetrieveCumulativeBalanceResponse|bool
     */
    public function RetrieveCumulativeBalance(\StructType\RetrieveCumulativeBalance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveCumulativeBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveCreditLimitHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveCreditLimitHistory $parameters
     * @return \StructType\RetrieveCreditLimitHistoryResponse|bool
     */
    public function RetrieveCreditLimitHistory(\StructType\RetrieveCreditLimitHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveCreditLimitHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFinanceAgents
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFinanceAgents $parameters
     * @return \StructType\RetrieveFinanceAgentsResponse|bool
     */
    public function RetrieveFinanceAgents(\StructType\RetrieveFinanceAgents $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFinanceAgents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSubAgencies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSubAgencies $parameters
     * @return \StructType\RetrieveSubAgenciesResponse|bool
     */
    public function RetrieveSubAgencies(\StructType\RetrieveSubAgencies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSubAgencies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveDistributorDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveDistributorDetails $parameters
     * @return \StructType\RetrieveDistributorDetailsResponse|bool
     */
    public function RetrieveDistributorDetails(\StructType\RetrieveDistributorDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveDistributorDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveChangedTAData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveChangedTAData $parameters
     * @return \StructType\RetrieveChangedTADataResponse|bool
     */
    public function RetrieveChangedTAData(\StructType\RetrieveChangedTAData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveChangedTAData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgencyIncentiveReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgencyIncentiveReport $parameters
     * @return \StructType\RetrieveAgencyIncentiveReportResponse|bool
     */
    public function RetrieveAgencyIncentiveReport(\StructType\RetrieveAgencyIncentiveReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgencyIncentiveReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAgencyPNR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAgencyPNR $parameters
     * @return \StructType\RetrieveAgencyPNRResponse|bool
     */
    public function RetrieveAgencyPNR(\StructType\RetrieveAgencyPNR $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAgencyPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RetrieveBookingsWithPaymentsPending
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveBookingsWithPaymentsPending $parameters
     * @return \StructType\RetrieveBookingsWithPaymentsPendingResponse|bool
     */
    public function RetrieveBookingsWithPaymentsPending(\StructType\RetrieveBookingsWithPaymentsPending $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveBookingsWithPaymentsPending($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveAgencyCommissionResponse|\StructType\RetrieveAgencyDetailsResponse|\StructType\RetrieveAgencyIncentiveReportResponse|\StructType\RetrieveAgencyInfoResponse|\StructType\RetrieveAgencyListResponse|\StructType\RetrieveAgencyPNRResponse|\StructType\RetrieveAgencywithCCInfoResponse|\StructType\RetrieveAgentDetailsResponse|\StructType\RetrieveAgentListResponse|\StructType\RetrieveAvailableAgencyCreditResponse|\StructType\RetrieveAvailableCreditResponse|\StructType\RetrieveBalanceDashboardInfoResponse|\StructType\RetrieveBookingHistoryResponse|\StructType\RetrieveBookingsWithPaymentsPendingResponse|\StructType\RetrieveChangedTADataResponse|\StructType\RetrieveCommissionDashboardInfoResponse|\StructType\RetrieveCreditLimitHistoryResponse|\StructType\RetrieveCumulativeBalanceResponse|\StructType\RetrieveDisruptedAgencyPNRListResponse|\StructType\RetrieveDistributorDetailsResponse|\StructType\RetrieveFinanceAgentsResponse|\StructType\RetrieveSubAgenciesResponse|\StructType\RetrieveTransactionDashboardInfoResponse|\StructType\RetrieveTravelAgencyPNRListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
