<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoginTravelAgent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginTravelAgent $parameters
     * @return \StructType\LoginTravelAgentResponse|bool
     */
    public function LoginTravelAgent(\StructType\LoginTravelAgent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginTravelAgent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoginTravelAgentSingleSignOn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginTravelAgentSingleSignOn $parameters
     * @return \StructType\LoginTravelAgentSingleSignOnResponse|bool
     */
    public function LoginTravelAgentSingleSignOn(\StructType\LoginTravelAgentSingleSignOn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginTravelAgentSingleSignOn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoginTravelAgentResponse|\StructType\LoginTravelAgentSingleSignOnResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
