<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBalanceInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBalanceInfo
 * @subpackage Arrays
 */
class ArrayOfBalanceInfo extends AbstractStructArrayBase
{
    /**
     * The BalanceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BalanceInfo[]
     */
    public $BalanceInfo;
    /**
     * Constructor method for ArrayOfBalanceInfo
     * @uses ArrayOfBalanceInfo::setBalanceInfo()
     * @param \StructType\BalanceInfo[] $balanceInfo
     */
    public function __construct(array $balanceInfo = array())
    {
        $this
            ->setBalanceInfo($balanceInfo);
    }
    /**
     * Get BalanceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BalanceInfo[]|null
     */
    public function getBalanceInfo()
    {
        return isset($this->BalanceInfo) ? $this->BalanceInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBalanceInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBalanceInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBalanceInfoForArrayConstraintsFromSetBalanceInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBalanceInfoBalanceInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfBalanceInfoBalanceInfoItem instanceof \StructType\BalanceInfo) {
                $invalidValues[] = is_object($arrayOfBalanceInfoBalanceInfoItem) ? get_class($arrayOfBalanceInfoBalanceInfoItem) : sprintf('%s(%s)', gettype($arrayOfBalanceInfoBalanceInfoItem), var_export($arrayOfBalanceInfoBalanceInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BalanceInfo property can only contain items of type \StructType\BalanceInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BalanceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BalanceInfo[] $balanceInfo
     * @return \ArrayType\ArrayOfBalanceInfo
     */
    public function setBalanceInfo(array $balanceInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($balanceInfoArrayErrorMessage = self::validateBalanceInfoForArrayConstraintsFromSetBalanceInfo($balanceInfo))) {
            throw new \InvalidArgumentException($balanceInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($balanceInfo) || (is_array($balanceInfo) && empty($balanceInfo))) {
            unset($this->BalanceInfo);
        } else {
            $this->BalanceInfo = $balanceInfo;
        }
        return $this;
    }
    /**
     * Add item to BalanceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\BalanceInfo $item
     * @return \ArrayType\ArrayOfBalanceInfo
     */
    public function addToBalanceInfo(\StructType\BalanceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BalanceInfo) {
            throw new \InvalidArgumentException(sprintf('The BalanceInfo property can only contain items of type \StructType\BalanceInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BalanceInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BalanceInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BalanceInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BalanceInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BalanceInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BalanceInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BalanceInfo
     */
    public function getAttributeName()
    {
        return 'BalanceInfo';
    }
}
