<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewCumulativeBalance StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewCumulativeBalance
 * @subpackage Structs
 */
class ViewCumulativeBalance extends AbstractStructBase
{
    /**
     * The TotalCharges
     * @var float
     */
    public $TotalCharges;
    /**
     * The TotalPayments
     * @var float
     */
    public $TotalPayments;
    /**
     * Constructor method for ViewCumulativeBalance
     * @uses ViewCumulativeBalance::setTotalCharges()
     * @uses ViewCumulativeBalance::setTotalPayments()
     * @param float $totalCharges
     * @param float $totalPayments
     */
    public function __construct($totalCharges = null, $totalPayments = null)
    {
        $this
            ->setTotalCharges($totalCharges)
            ->setTotalPayments($totalPayments);
    }
    /**
     * Get TotalCharges value
     * @return float|null
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param float $totalCharges
     * @return \StructType\ViewCumulativeBalance
     */
    public function setTotalCharges($totalCharges = null)
    {
        // validation for constraint: float
        if (!is_null($totalCharges) && !(is_float($totalCharges) || is_numeric($totalCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCharges, true), gettype($totalCharges)), __LINE__);
        }
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get TotalPayments value
     * @return float|null
     */
    public function getTotalPayments()
    {
        return $this->TotalPayments;
    }
    /**
     * Set TotalPayments value
     * @param float $totalPayments
     * @return \StructType\ViewCumulativeBalance
     */
    public function setTotalPayments($totalPayments = null)
    {
        // validation for constraint: float
        if (!is_null($totalPayments) && !(is_float($totalPayments) || is_numeric($totalPayments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPayments, true), gettype($totalPayments)), __LINE__);
        }
        $this->TotalPayments = $totalPayments;
        return $this;
    }
}
