<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewAgencyIncentiveReport StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewAgencyIncentiveReport
 * @subpackage Structs
 */
class ViewAgencyIncentiveReport extends AbstractStructBase
{
    /**
     * The ParentIATA
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ParentIATA;
    /**
     * The IATANum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANum;
    /**
     * The ReportedCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReportedCurrency;
    /**
     * The ReportedAmount
     * @var float
     */
    public $ReportedAmount;
    /**
     * Constructor method for ViewAgencyIncentiveReport
     * @uses ViewAgencyIncentiveReport::setParentIATA()
     * @uses ViewAgencyIncentiveReport::setIATANum()
     * @uses ViewAgencyIncentiveReport::setReportedCurrency()
     * @uses ViewAgencyIncentiveReport::setReportedAmount()
     * @param string $parentIATA
     * @param string $iATANum
     * @param string $reportedCurrency
     * @param float $reportedAmount
     */
    public function __construct($parentIATA = null, $iATANum = null, $reportedCurrency = null, $reportedAmount = null)
    {
        $this
            ->setParentIATA($parentIATA)
            ->setIATANum($iATANum)
            ->setReportedCurrency($reportedCurrency)
            ->setReportedAmount($reportedAmount);
    }
    /**
     * Get ParentIATA value
     * @return string|null
     */
    public function getParentIATA()
    {
        return $this->ParentIATA;
    }
    /**
     * Set ParentIATA value
     * @param string $parentIATA
     * @return \StructType\ViewAgencyIncentiveReport
     */
    public function setParentIATA($parentIATA = null)
    {
        // validation for constraint: string
        if (!is_null($parentIATA) && !is_string($parentIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentIATA, true), gettype($parentIATA)), __LINE__);
        }
        $this->ParentIATA = $parentIATA;
        return $this;
    }
    /**
     * Get IATANum value
     * @return string|null
     */
    public function getIATANum()
    {
        return $this->IATANum;
    }
    /**
     * Set IATANum value
     * @param string $iATANum
     * @return \StructType\ViewAgencyIncentiveReport
     */
    public function setIATANum($iATANum = null)
    {
        // validation for constraint: string
        if (!is_null($iATANum) && !is_string($iATANum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANum, true), gettype($iATANum)), __LINE__);
        }
        $this->IATANum = $iATANum;
        return $this;
    }
    /**
     * Get ReportedCurrency value
     * @return string|null
     */
    public function getReportedCurrency()
    {
        return $this->ReportedCurrency;
    }
    /**
     * Set ReportedCurrency value
     * @param string $reportedCurrency
     * @return \StructType\ViewAgencyIncentiveReport
     */
    public function setReportedCurrency($reportedCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($reportedCurrency) && !is_string($reportedCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportedCurrency, true), gettype($reportedCurrency)), __LINE__);
        }
        $this->ReportedCurrency = $reportedCurrency;
        return $this;
    }
    /**
     * Get ReportedAmount value
     * @return float|null
     */
    public function getReportedAmount()
    {
        return $this->ReportedAmount;
    }
    /**
     * Set ReportedAmount value
     * @param float $reportedAmount
     * @return \StructType\ViewAgencyIncentiveReport
     */
    public function setReportedAmount($reportedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($reportedAmount) && !(is_float($reportedAmount) || is_numeric($reportedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reportedAmount, true), gettype($reportedAmount)), __LINE__);
        }
        $this->ReportedAmount = $reportedAmount;
        return $this;
    }
}
