<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionInfo
 * @subpackage Structs
 */
class TransactionInfo extends AbstractStructBase
{
    /**
     * The SecurityGUID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SecurityGUID;
    /**
     * The CarrierCodes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCarrierCode
     */
    public $CarrierCodes;
    /**
     * The ClientIPAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIPAddress;
    /**
     * The HistoricUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HistoricUserName;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookingUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingUserName;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The TransactionIATA
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TransactionIATA;
    /**
     * The PaymentUserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentUserName;
    /**
     * The TransactionDate
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionType
     * @var string
     */
    public $TransactionType;
    /**
     * The TransactionCurrency
     * @var string
     */
    public $TransactionCurrency;
    /**
     * The TransactionAmount
     * @var float
     */
    public $TransactionAmount;
    /**
     * The TransactionBalance
     * @var float
     */
    public $TransactionBalance;
    /**
     * Constructor method for TransactionInfo
     * @uses TransactionInfo::setSecurityGUID()
     * @uses TransactionInfo::setCarrierCodes()
     * @uses TransactionInfo::setClientIPAddress()
     * @uses TransactionInfo::setHistoricUserName()
     * @uses TransactionInfo::setInvoiceNumber()
     * @uses TransactionInfo::setConfirmationNumber()
     * @uses TransactionInfo::setBookingUserName()
     * @uses TransactionInfo::setIATANumber()
     * @uses TransactionInfo::setTransactionIATA()
     * @uses TransactionInfo::setPaymentUserName()
     * @uses TransactionInfo::setTransactionDate()
     * @uses TransactionInfo::setTransactionType()
     * @uses TransactionInfo::setTransactionCurrency()
     * @uses TransactionInfo::setTransactionAmount()
     * @uses TransactionInfo::setTransactionBalance()
     * @param string $securityGUID
     * @param \ArrayType\ArrayOfCarrierCode $carrierCodes
     * @param string $clientIPAddress
     * @param string $historicUserName
     * @param string $invoiceNumber
     * @param string $confirmationNumber
     * @param string $bookingUserName
     * @param string $iATANumber
     * @param string $transactionIATA
     * @param string $paymentUserName
     * @param string $transactionDate
     * @param string $transactionType
     * @param string $transactionCurrency
     * @param float $transactionAmount
     * @param float $transactionBalance
     */
    public function __construct($securityGUID = null, \ArrayType\ArrayOfCarrierCode $carrierCodes = null, $clientIPAddress = null, $historicUserName = null, $invoiceNumber = null, $confirmationNumber = null, $bookingUserName = null, $iATANumber = null, $transactionIATA = null, $paymentUserName = null, $transactionDate = null, $transactionType = null, $transactionCurrency = null, $transactionAmount = null, $transactionBalance = null)
    {
        $this
            ->setSecurityGUID($securityGUID)
            ->setCarrierCodes($carrierCodes)
            ->setClientIPAddress($clientIPAddress)
            ->setHistoricUserName($historicUserName)
            ->setInvoiceNumber($invoiceNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setBookingUserName($bookingUserName)
            ->setIATANumber($iATANumber)
            ->setTransactionIATA($transactionIATA)
            ->setPaymentUserName($paymentUserName)
            ->setTransactionDate($transactionDate)
            ->setTransactionType($transactionType)
            ->setTransactionCurrency($transactionCurrency)
            ->setTransactionAmount($transactionAmount)
            ->setTransactionBalance($transactionBalance);
    }
    /**
     * Get SecurityGUID value
     * @return string|null
     */
    public function getSecurityGUID()
    {
        return $this->SecurityGUID;
    }
    /**
     * Set SecurityGUID value
     * @param string $securityGUID
     * @return \StructType\TransactionInfo
     */
    public function setSecurityGUID($securityGUID = null)
    {
        // validation for constraint: string
        if (!is_null($securityGUID) && !is_string($securityGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityGUID, true), gettype($securityGUID)), __LINE__);
        }
        $this->SecurityGUID = $securityGUID;
        return $this;
    }
    /**
     * Get CarrierCodes value
     * @return \ArrayType\ArrayOfCarrierCode|null
     */
    public function getCarrierCodes()
    {
        return $this->CarrierCodes;
    }
    /**
     * Set CarrierCodes value
     * @param \ArrayType\ArrayOfCarrierCode $carrierCodes
     * @return \StructType\TransactionInfo
     */
    public function setCarrierCodes(\ArrayType\ArrayOfCarrierCode $carrierCodes = null)
    {
        $this->CarrierCodes = $carrierCodes;
        return $this;
    }
    /**
     * Get ClientIPAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIPAddress()
    {
        return isset($this->ClientIPAddress) ? $this->ClientIPAddress : null;
    }
    /**
     * Set ClientIPAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIPAddress
     * @return \StructType\TransactionInfo
     */
    public function setClientIPAddress($clientIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($clientIPAddress) && !is_string($clientIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIPAddress, true), gettype($clientIPAddress)), __LINE__);
        }
        if (is_null($clientIPAddress) || (is_array($clientIPAddress) && empty($clientIPAddress))) {
            unset($this->ClientIPAddress);
        } else {
            $this->ClientIPAddress = $clientIPAddress;
        }
        return $this;
    }
    /**
     * Get HistoricUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoricUserName()
    {
        return isset($this->HistoricUserName) ? $this->HistoricUserName : null;
    }
    /**
     * Set HistoricUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historicUserName
     * @return \StructType\TransactionInfo
     */
    public function setHistoricUserName($historicUserName = null)
    {
        // validation for constraint: string
        if (!is_null($historicUserName) && !is_string($historicUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historicUserName, true), gettype($historicUserName)), __LINE__);
        }
        if (is_null($historicUserName) || (is_array($historicUserName) && empty($historicUserName))) {
            unset($this->HistoricUserName);
        } else {
            $this->HistoricUserName = $historicUserName;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\TransactionInfo
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\TransactionInfo
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get BookingUserName value
     * @return string|null
     */
    public function getBookingUserName()
    {
        return $this->BookingUserName;
    }
    /**
     * Set BookingUserName value
     * @param string $bookingUserName
     * @return \StructType\TransactionInfo
     */
    public function setBookingUserName($bookingUserName = null)
    {
        // validation for constraint: string
        if (!is_null($bookingUserName) && !is_string($bookingUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingUserName, true), gettype($bookingUserName)), __LINE__);
        }
        $this->BookingUserName = $bookingUserName;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\TransactionInfo
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get TransactionIATA value
     * @return string|null
     */
    public function getTransactionIATA()
    {
        return $this->TransactionIATA;
    }
    /**
     * Set TransactionIATA value
     * @param string $transactionIATA
     * @return \StructType\TransactionInfo
     */
    public function setTransactionIATA($transactionIATA = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIATA) && !is_string($transactionIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIATA, true), gettype($transactionIATA)), __LINE__);
        }
        $this->TransactionIATA = $transactionIATA;
        return $this;
    }
    /**
     * Get PaymentUserName value
     * @return string|null
     */
    public function getPaymentUserName()
    {
        return $this->PaymentUserName;
    }
    /**
     * Set PaymentUserName value
     * @param string $paymentUserName
     * @return \StructType\TransactionInfo
     */
    public function setPaymentUserName($paymentUserName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentUserName) && !is_string($paymentUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentUserName, true), gettype($paymentUserName)), __LINE__);
        }
        $this->PaymentUserName = $paymentUserName;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\TransactionInfo
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\Enumerations_ARTransactionTypes::valueIsValid()
     * @uses \EnumType\Enumerations_ARTransactionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\TransactionInfo
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ARTransactionTypes::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ARTransactionTypes', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\Enumerations_ARTransactionTypes::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get TransactionCurrency value
     * @return string|null
     */
    public function getTransactionCurrency()
    {
        return $this->TransactionCurrency;
    }
    /**
     * Set TransactionCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionCurrency
     * @return \StructType\TransactionInfo
     */
    public function setTransactionCurrency($transactionCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($transactionCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($transactionCurrency) ? implode(', ', $transactionCurrency) : var_export($transactionCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->TransactionCurrency = $transactionCurrency;
        return $this;
    }
    /**
     * Get TransactionAmount value
     * @return float|null
     */
    public function getTransactionAmount()
    {
        return $this->TransactionAmount;
    }
    /**
     * Set TransactionAmount value
     * @param float $transactionAmount
     * @return \StructType\TransactionInfo
     */
    public function setTransactionAmount($transactionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($transactionAmount) && !(is_float($transactionAmount) || is_numeric($transactionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transactionAmount, true), gettype($transactionAmount)), __LINE__);
        }
        $this->TransactionAmount = $transactionAmount;
        return $this;
    }
    /**
     * Get TransactionBalance value
     * @return float|null
     */
    public function getTransactionBalance()
    {
        return $this->TransactionBalance;
    }
    /**
     * Set TransactionBalance value
     * @param float $transactionBalance
     * @return \StructType\TransactionInfo
     */
    public function setTransactionBalance($transactionBalance = null)
    {
        // validation for constraint: float
        if (!is_null($transactionBalance) && !(is_float($transactionBalance) || is_numeric($transactionBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transactionBalance, true), gettype($transactionBalance)), __LINE__);
        }
        $this->TransactionBalance = $transactionBalance;
        return $this;
    }
}
