<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSubAgencies StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSubAgencies
 * @subpackage Structs
 */
class RetrieveSubAgencies extends TransactionInfo
{
    /**
     * The RetrieveSubAgenciesRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveSubAgencies
     */
    public $RetrieveSubAgenciesRequest;
    /**
     * The AgencyInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AgencyInfo
     */
    public $AgencyInformation;
    /**
     * The IncludeInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeInactive;
    /**
     * Constructor method for RetrieveSubAgencies
     * @uses RetrieveSubAgencies::setRetrieveSubAgenciesRequest()
     * @uses RetrieveSubAgencies::setAgencyInformation()
     * @uses RetrieveSubAgencies::setIncludeInactive()
     * @param \StructType\RetrieveSubAgencies $retrieveSubAgenciesRequest
     * @param \StructType\AgencyInfo $agencyInformation
     * @param string $includeInactive
     */
    public function __construct(\StructType\RetrieveSubAgencies $retrieveSubAgenciesRequest = null, \StructType\AgencyInfo $agencyInformation = null, $includeInactive = null)
    {
        $this
            ->setRetrieveSubAgenciesRequest($retrieveSubAgenciesRequest)
            ->setAgencyInformation($agencyInformation)
            ->setIncludeInactive($includeInactive);
    }
    /**
     * Get RetrieveSubAgenciesRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveSubAgencies|null
     */
    public function getRetrieveSubAgenciesRequest()
    {
        return isset($this->RetrieveSubAgenciesRequest) ? $this->RetrieveSubAgenciesRequest : null;
    }
    /**
     * Set RetrieveSubAgenciesRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveSubAgencies $retrieveSubAgenciesRequest
     * @return \StructType\RetrieveSubAgencies
     */
    public function setRetrieveSubAgenciesRequest(\StructType\RetrieveSubAgencies $retrieveSubAgenciesRequest = null)
    {
        if (is_null($retrieveSubAgenciesRequest) || (is_array($retrieveSubAgenciesRequest) && empty($retrieveSubAgenciesRequest))) {
            unset($this->RetrieveSubAgenciesRequest);
        } else {
            $this->RetrieveSubAgenciesRequest = $retrieveSubAgenciesRequest;
        }
        return $this;
    }
    /**
     * Get AgencyInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AgencyInfo|null
     */
    public function getAgencyInformation()
    {
        return isset($this->AgencyInformation) ? $this->AgencyInformation : null;
    }
    /**
     * Set AgencyInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AgencyInfo $agencyInformation
     * @return \StructType\RetrieveSubAgencies
     */
    public function setAgencyInformation(\StructType\AgencyInfo $agencyInformation = null)
    {
        if (is_null($agencyInformation) || (is_array($agencyInformation) && empty($agencyInformation))) {
            unset($this->AgencyInformation);
        } else {
            $this->AgencyInformation = $agencyInformation;
        }
        return $this;
    }
    /**
     * Get IncludeInactive value
     * @return string|null
     */
    public function getIncludeInactive()
    {
        return $this->IncludeInactive;
    }
    /**
     * Set IncludeInactive value
     * @uses \EnumType\Enumerations_AnswerTypes::valueIsValid()
     * @uses \EnumType\Enumerations_AnswerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeInactive
     * @return \StructType\RetrieveSubAgencies
     */
    public function setIncludeInactive($includeInactive = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AnswerTypes::valueIsValid($includeInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AnswerTypes', is_array($includeInactive) ? implode(', ', $includeInactive) : var_export($includeInactive, true), implode(', ', \EnumType\Enumerations_AnswerTypes::getValidValues())), __LINE__);
        }
        $this->IncludeInactive = $includeInactive;
        return $this;
    }
}
