<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveCreditLimitHistory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveCreditLimitHistory
 * @subpackage Structs
 */
class RetrieveCreditLimitHistory extends TransactionInfo
{
    /**
     * The RetrieveCreditLimitHistoryRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveCreditLimitHistory
     */
    public $RetrieveCreditLimitHistoryRequest;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The IncludeChildAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeChildAgent;
    /**
     * The ReportDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReportDateFrom;
    /**
     * The ReportDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReportDateTo;
    /**
     * Constructor method for RetrieveCreditLimitHistory
     * @uses RetrieveCreditLimitHistory::setRetrieveCreditLimitHistoryRequest()
     * @uses RetrieveCreditLimitHistory::setAmount()
     * @uses RetrieveCreditLimitHistory::setIATANumber()
     * @uses RetrieveCreditLimitHistory::setIncludeChildAgent()
     * @uses RetrieveCreditLimitHistory::setReportDateFrom()
     * @uses RetrieveCreditLimitHistory::setReportDateTo()
     * @param \StructType\RetrieveCreditLimitHistory $retrieveCreditLimitHistoryRequest
     * @param float $amount
     * @param string $iATANumber
     * @param string $includeChildAgent
     * @param string $reportDateFrom
     * @param string $reportDateTo
     */
    public function __construct(\StructType\RetrieveCreditLimitHistory $retrieveCreditLimitHistoryRequest = null, $amount = null, $iATANumber = null, $includeChildAgent = null, $reportDateFrom = null, $reportDateTo = null)
    {
        $this
            ->setRetrieveCreditLimitHistoryRequest($retrieveCreditLimitHistoryRequest)
            ->setAmount($amount)
            ->setIATANumber($iATANumber)
            ->setIncludeChildAgent($includeChildAgent)
            ->setReportDateFrom($reportDateFrom)
            ->setReportDateTo($reportDateTo);
    }
    /**
     * Get RetrieveCreditLimitHistoryRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveCreditLimitHistory|null
     */
    public function getRetrieveCreditLimitHistoryRequest()
    {
        return isset($this->RetrieveCreditLimitHistoryRequest) ? $this->RetrieveCreditLimitHistoryRequest : null;
    }
    /**
     * Set RetrieveCreditLimitHistoryRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveCreditLimitHistory $retrieveCreditLimitHistoryRequest
     * @return \StructType\RetrieveCreditLimitHistory
     */
    public function setRetrieveCreditLimitHistoryRequest(\StructType\RetrieveCreditLimitHistory $retrieveCreditLimitHistoryRequest = null)
    {
        if (is_null($retrieveCreditLimitHistoryRequest) || (is_array($retrieveCreditLimitHistoryRequest) && empty($retrieveCreditLimitHistoryRequest))) {
            unset($this->RetrieveCreditLimitHistoryRequest);
        } else {
            $this->RetrieveCreditLimitHistoryRequest = $retrieveCreditLimitHistoryRequest;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \StructType\RetrieveCreditLimitHistory
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\RetrieveCreditLimitHistory
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
    /**
     * Get IncludeChildAgent value
     * @return string|null
     */
    public function getIncludeChildAgent()
    {
        return $this->IncludeChildAgent;
    }
    /**
     * Set IncludeChildAgent value
     * @uses \EnumType\Enumerations_AnswerTypes::valueIsValid()
     * @uses \EnumType\Enumerations_AnswerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeChildAgent
     * @return \StructType\RetrieveCreditLimitHistory
     */
    public function setIncludeChildAgent($includeChildAgent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_AnswerTypes::valueIsValid($includeChildAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_AnswerTypes', is_array($includeChildAgent) ? implode(', ', $includeChildAgent) : var_export($includeChildAgent, true), implode(', ', \EnumType\Enumerations_AnswerTypes::getValidValues())), __LINE__);
        }
        $this->IncludeChildAgent = $includeChildAgent;
        return $this;
    }
    /**
     * Get ReportDateFrom value
     * @return string|null
     */
    public function getReportDateFrom()
    {
        return $this->ReportDateFrom;
    }
    /**
     * Set ReportDateFrom value
     * @param string $reportDateFrom
     * @return \StructType\RetrieveCreditLimitHistory
     */
    public function setReportDateFrom($reportDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($reportDateFrom) && !is_string($reportDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportDateFrom, true), gettype($reportDateFrom)), __LINE__);
        }
        $this->ReportDateFrom = $reportDateFrom;
        return $this;
    }
    /**
     * Get ReportDateTo value
     * @return string|null
     */
    public function getReportDateTo()
    {
        return $this->ReportDateTo;
    }
    /**
     * Set ReportDateTo value
     * @param string $reportDateTo
     * @return \StructType\RetrieveCreditLimitHistory
     */
    public function setReportDateTo($reportDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($reportDateTo) && !is_string($reportDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportDateTo, true), gettype($reportDateTo)), __LINE__);
        }
        $this->ReportDateTo = $reportDateTo;
        return $this;
    }
}
