<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveChangedTAData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveChangedTAData
 * @subpackage Structs
 */
class RetrieveChangedTAData extends TransactionInfo
{
    /**
     * The RetrieveChangedTADataRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveChangedTAData
     */
    public $RetrieveChangedTADataRequest;
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTo;
    /**
     * The OutputFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEnumerations_AgencyFields
     */
    public $OutputFields;
    /**
     * Constructor method for RetrieveChangedTAData
     * @uses RetrieveChangedTAData::setRetrieveChangedTADataRequest()
     * @uses RetrieveChangedTAData::setDateFrom()
     * @uses RetrieveChangedTAData::setDateTo()
     * @uses RetrieveChangedTAData::setOutputFields()
     * @param \StructType\RetrieveChangedTAData $retrieveChangedTADataRequest
     * @param string $dateFrom
     * @param string $dateTo
     * @param \ArrayType\ArrayOfEnumerations_AgencyFields $outputFields
     */
    public function __construct(\StructType\RetrieveChangedTAData $retrieveChangedTADataRequest = null, $dateFrom = null, $dateTo = null, \ArrayType\ArrayOfEnumerations_AgencyFields $outputFields = null)
    {
        $this
            ->setRetrieveChangedTADataRequest($retrieveChangedTADataRequest)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setOutputFields($outputFields);
    }
    /**
     * Get RetrieveChangedTADataRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveChangedTAData|null
     */
    public function getRetrieveChangedTADataRequest()
    {
        return isset($this->RetrieveChangedTADataRequest) ? $this->RetrieveChangedTADataRequest : null;
    }
    /**
     * Set RetrieveChangedTADataRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveChangedTAData $retrieveChangedTADataRequest
     * @return \StructType\RetrieveChangedTAData
     */
    public function setRetrieveChangedTADataRequest(\StructType\RetrieveChangedTAData $retrieveChangedTADataRequest = null)
    {
        if (is_null($retrieveChangedTADataRequest) || (is_array($retrieveChangedTADataRequest) && empty($retrieveChangedTADataRequest))) {
            unset($this->RetrieveChangedTADataRequest);
        } else {
            $this->RetrieveChangedTADataRequest = $retrieveChangedTADataRequest;
        }
        return $this;
    }
    /**
     * Get DateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param string $dateFrom
     * @return \StructType\RetrieveChangedTAData
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param string $dateTo
     * @return \StructType\RetrieveChangedTAData
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get OutputFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEnumerations_AgencyFields|null
     */
    public function getOutputFields()
    {
        return isset($this->OutputFields) ? $this->OutputFields : null;
    }
    /**
     * Set OutputFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEnumerations_AgencyFields $outputFields
     * @return \StructType\RetrieveChangedTAData
     */
    public function setOutputFields(\ArrayType\ArrayOfEnumerations_AgencyFields $outputFields = null)
    {
        if (is_null($outputFields) || (is_array($outputFields) && empty($outputFields))) {
            unset($this->OutputFields);
        } else {
            $this->OutputFields = $outputFields;
        }
        return $this;
    }
}
