<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgencyIncentiveReport StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgencyIncentiveReport
 * @subpackage Structs
 */
class RetrieveAgencyIncentiveReport extends TransactionInfo
{
    /**
     * The RetrieveAgencyIncentiveReportRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgencyIncentiveReport
     */
    public $RetrieveAgencyIncentiveReportRequest;
    /**
     * The AgencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgencyCode;
    /**
     * The ChargeCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfChargeCode
     */
    public $ChargeCodes;
    /**
     * The DepartureEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureEndDate;
    /**
     * The DepartureStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureStartDate;
    /**
     * The EmailId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailId;
    /**
     * The PaymentEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentEndDate;
    /**
     * The PaymentStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStartDate;
    /**
     * The ReportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportType;
    /**
     * The SegmentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEnumerations_SegmentStatus
     */
    public $SegmentStatus;
    /**
     * Constructor method for RetrieveAgencyIncentiveReport
     * @uses RetrieveAgencyIncentiveReport::setRetrieveAgencyIncentiveReportRequest()
     * @uses RetrieveAgencyIncentiveReport::setAgencyCode()
     * @uses RetrieveAgencyIncentiveReport::setChargeCodes()
     * @uses RetrieveAgencyIncentiveReport::setDepartureEndDate()
     * @uses RetrieveAgencyIncentiveReport::setDepartureStartDate()
     * @uses RetrieveAgencyIncentiveReport::setEmailId()
     * @uses RetrieveAgencyIncentiveReport::setPaymentEndDate()
     * @uses RetrieveAgencyIncentiveReport::setPaymentStartDate()
     * @uses RetrieveAgencyIncentiveReport::setReportType()
     * @uses RetrieveAgencyIncentiveReport::setSegmentStatus()
     * @param \StructType\RetrieveAgencyIncentiveReport $retrieveAgencyIncentiveReportRequest
     * @param string $agencyCode
     * @param \ArrayType\ArrayOfChargeCode $chargeCodes
     * @param string $departureEndDate
     * @param string $departureStartDate
     * @param string $emailId
     * @param string $paymentEndDate
     * @param string $paymentStartDate
     * @param string $reportType
     * @param \ArrayType\ArrayOfEnumerations_SegmentStatus $segmentStatus
     */
    public function __construct(\StructType\RetrieveAgencyIncentiveReport $retrieveAgencyIncentiveReportRequest = null, $agencyCode = null, \ArrayType\ArrayOfChargeCode $chargeCodes = null, $departureEndDate = null, $departureStartDate = null, $emailId = null, $paymentEndDate = null, $paymentStartDate = null, $reportType = null, \ArrayType\ArrayOfEnumerations_SegmentStatus $segmentStatus = null)
    {
        $this
            ->setRetrieveAgencyIncentiveReportRequest($retrieveAgencyIncentiveReportRequest)
            ->setAgencyCode($agencyCode)
            ->setChargeCodes($chargeCodes)
            ->setDepartureEndDate($departureEndDate)
            ->setDepartureStartDate($departureStartDate)
            ->setEmailId($emailId)
            ->setPaymentEndDate($paymentEndDate)
            ->setPaymentStartDate($paymentStartDate)
            ->setReportType($reportType)
            ->setSegmentStatus($segmentStatus);
    }
    /**
     * Get RetrieveAgencyIncentiveReportRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgencyIncentiveReport|null
     */
    public function getRetrieveAgencyIncentiveReportRequest()
    {
        return isset($this->RetrieveAgencyIncentiveReportRequest) ? $this->RetrieveAgencyIncentiveReportRequest : null;
    }
    /**
     * Set RetrieveAgencyIncentiveReportRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgencyIncentiveReport $retrieveAgencyIncentiveReportRequest
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setRetrieveAgencyIncentiveReportRequest(\StructType\RetrieveAgencyIncentiveReport $retrieveAgencyIncentiveReportRequest = null)
    {
        if (is_null($retrieveAgencyIncentiveReportRequest) || (is_array($retrieveAgencyIncentiveReportRequest) && empty($retrieveAgencyIncentiveReportRequest))) {
            unset($this->RetrieveAgencyIncentiveReportRequest);
        } else {
            $this->RetrieveAgencyIncentiveReportRequest = $retrieveAgencyIncentiveReportRequest;
        }
        return $this;
    }
    /**
     * Get AgencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyCode()
    {
        return isset($this->AgencyCode) ? $this->AgencyCode : null;
    }
    /**
     * Set AgencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyCode
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setAgencyCode($agencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCode) && !is_string($agencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCode, true), gettype($agencyCode)), __LINE__);
        }
        if (is_null($agencyCode) || (is_array($agencyCode) && empty($agencyCode))) {
            unset($this->AgencyCode);
        } else {
            $this->AgencyCode = $agencyCode;
        }
        return $this;
    }
    /**
     * Get ChargeCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfChargeCode|null
     */
    public function getChargeCodes()
    {
        return isset($this->ChargeCodes) ? $this->ChargeCodes : null;
    }
    /**
     * Set ChargeCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfChargeCode $chargeCodes
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setChargeCodes(\ArrayType\ArrayOfChargeCode $chargeCodes = null)
    {
        if (is_null($chargeCodes) || (is_array($chargeCodes) && empty($chargeCodes))) {
            unset($this->ChargeCodes);
        } else {
            $this->ChargeCodes = $chargeCodes;
        }
        return $this;
    }
    /**
     * Get DepartureEndDate value
     * @return string|null
     */
    public function getDepartureEndDate()
    {
        return $this->DepartureEndDate;
    }
    /**
     * Set DepartureEndDate value
     * @param string $departureEndDate
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setDepartureEndDate($departureEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureEndDate) && !is_string($departureEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureEndDate, true), gettype($departureEndDate)), __LINE__);
        }
        $this->DepartureEndDate = $departureEndDate;
        return $this;
    }
    /**
     * Get DepartureStartDate value
     * @return string|null
     */
    public function getDepartureStartDate()
    {
        return $this->DepartureStartDate;
    }
    /**
     * Set DepartureStartDate value
     * @param string $departureStartDate
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setDepartureStartDate($departureStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureStartDate) && !is_string($departureStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureStartDate, true), gettype($departureStartDate)), __LINE__);
        }
        $this->DepartureStartDate = $departureStartDate;
        return $this;
    }
    /**
     * Get EmailId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailId()
    {
        return isset($this->EmailId) ? $this->EmailId : null;
    }
    /**
     * Set EmailId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailId
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setEmailId($emailId = null)
    {
        // validation for constraint: string
        if (!is_null($emailId) && !is_string($emailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailId, true), gettype($emailId)), __LINE__);
        }
        if (is_null($emailId) || (is_array($emailId) && empty($emailId))) {
            unset($this->EmailId);
        } else {
            $this->EmailId = $emailId;
        }
        return $this;
    }
    /**
     * Get PaymentEndDate value
     * @return string|null
     */
    public function getPaymentEndDate()
    {
        return $this->PaymentEndDate;
    }
    /**
     * Set PaymentEndDate value
     * @param string $paymentEndDate
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setPaymentEndDate($paymentEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentEndDate) && !is_string($paymentEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentEndDate, true), gettype($paymentEndDate)), __LINE__);
        }
        $this->PaymentEndDate = $paymentEndDate;
        return $this;
    }
    /**
     * Get PaymentStartDate value
     * @return string|null
     */
    public function getPaymentStartDate()
    {
        return $this->PaymentStartDate;
    }
    /**
     * Set PaymentStartDate value
     * @param string $paymentStartDate
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setPaymentStartDate($paymentStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStartDate) && !is_string($paymentStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStartDate, true), gettype($paymentStartDate)), __LINE__);
        }
        $this->PaymentStartDate = $paymentStartDate;
        return $this;
    }
    /**
     * Get ReportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportType()
    {
        return isset($this->ReportType) ? $this->ReportType : null;
    }
    /**
     * Set ReportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportType
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setReportType($reportType = null)
    {
        // validation for constraint: string
        if (!is_null($reportType) && !is_string($reportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportType, true), gettype($reportType)), __LINE__);
        }
        if (is_null($reportType) || (is_array($reportType) && empty($reportType))) {
            unset($this->ReportType);
        } else {
            $this->ReportType = $reportType;
        }
        return $this;
    }
    /**
     * Get SegmentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEnumerations_SegmentStatus|null
     */
    public function getSegmentStatus()
    {
        return isset($this->SegmentStatus) ? $this->SegmentStatus : null;
    }
    /**
     * Set SegmentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEnumerations_SegmentStatus $segmentStatus
     * @return \StructType\RetrieveAgencyIncentiveReport
     */
    public function setSegmentStatus(\ArrayType\ArrayOfEnumerations_SegmentStatus $segmentStatus = null)
    {
        if (is_null($segmentStatus) || (is_array($segmentStatus) && empty($segmentStatus))) {
            unset($this->SegmentStatus);
        } else {
            $this->SegmentStatus = $segmentStatus;
        }
        return $this;
    }
}
