<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAgencyDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAgencyDetails
 * @subpackage Structs
 */
class RetrieveAgencyDetails extends TransactionInfo
{
    /**
     * The RetrieveAgencyDetailsRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAgencyDetails
     */
    public $RetrieveAgencyDetailsRequest;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The IncludeChildAgents
     * @var bool
     */
    public $IncludeChildAgents;
    /**
     * Constructor method for RetrieveAgencyDetails
     * @uses RetrieveAgencyDetails::setRetrieveAgencyDetailsRequest()
     * @uses RetrieveAgencyDetails::setIATANumber()
     * @uses RetrieveAgencyDetails::setIncludeChildAgents()
     * @param \StructType\RetrieveAgencyDetails $retrieveAgencyDetailsRequest
     * @param string $iATANumber
     * @param bool $includeChildAgents
     */
    public function __construct(\StructType\RetrieveAgencyDetails $retrieveAgencyDetailsRequest = null, $iATANumber = null, $includeChildAgents = null)
    {
        $this
            ->setRetrieveAgencyDetailsRequest($retrieveAgencyDetailsRequest)
            ->setIATANumber($iATANumber)
            ->setIncludeChildAgents($includeChildAgents);
    }
    /**
     * Get RetrieveAgencyDetailsRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAgencyDetails|null
     */
    public function getRetrieveAgencyDetailsRequest()
    {
        return isset($this->RetrieveAgencyDetailsRequest) ? $this->RetrieveAgencyDetailsRequest : null;
    }
    /**
     * Set RetrieveAgencyDetailsRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAgencyDetails $retrieveAgencyDetailsRequest
     * @return \StructType\RetrieveAgencyDetails
     */
    public function setRetrieveAgencyDetailsRequest(\StructType\RetrieveAgencyDetails $retrieveAgencyDetailsRequest = null)
    {
        if (is_null($retrieveAgencyDetailsRequest) || (is_array($retrieveAgencyDetailsRequest) && empty($retrieveAgencyDetailsRequest))) {
            unset($this->RetrieveAgencyDetailsRequest);
        } else {
            $this->RetrieveAgencyDetailsRequest = $retrieveAgencyDetailsRequest;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\RetrieveAgencyDetails
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get IncludeChildAgents value
     * @return bool|null
     */
    public function getIncludeChildAgents()
    {
        return $this->IncludeChildAgents;
    }
    /**
     * Set IncludeChildAgents value
     * @param bool $includeChildAgents
     * @return \StructType\RetrieveAgencyDetails
     */
    public function setIncludeChildAgents($includeChildAgents = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildAgents) && !is_bool($includeChildAgents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildAgents, true), gettype($includeChildAgents)), __LINE__);
        }
        $this->IncludeChildAgents = $includeChildAgents;
        return $this;
    }
}
