<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChargeCode ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfChargeCode
 * @subpackage Arrays
 */
class ArrayOfChargeCode extends AbstractStructArrayBase
{
    /**
     * The ChargeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChargeCode[]
     */
    public $ChargeCode;
    /**
     * Constructor method for ArrayOfChargeCode
     * @uses ArrayOfChargeCode::setChargeCode()
     * @param \StructType\ChargeCode[] $chargeCode
     */
    public function __construct(array $chargeCode = array())
    {
        $this
            ->setChargeCode($chargeCode);
    }
    /**
     * Get ChargeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChargeCode[]|null
     */
    public function getChargeCode()
    {
        return isset($this->ChargeCode) ? $this->ChargeCode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setChargeCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChargeCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeCodeForArrayConstraintsFromSetChargeCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfChargeCodeChargeCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeCodeChargeCodeItem instanceof \StructType\ChargeCode) {
                $invalidValues[] = is_object($arrayOfChargeCodeChargeCodeItem) ? get_class($arrayOfChargeCodeChargeCodeItem) : sprintf('%s(%s)', gettype($arrayOfChargeCodeChargeCodeItem), var_export($arrayOfChargeCodeChargeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChargeCode property can only contain items of type \StructType\ChargeCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChargeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ChargeCode[] $chargeCode
     * @return \ArrayType\ArrayOfChargeCode
     */
    public function setChargeCode(array $chargeCode = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeCodeArrayErrorMessage = self::validateChargeCodeForArrayConstraintsFromSetChargeCode($chargeCode))) {
            throw new \InvalidArgumentException($chargeCodeArrayErrorMessage, __LINE__);
        }
        if (is_null($chargeCode) || (is_array($chargeCode) && empty($chargeCode))) {
            unset($this->ChargeCode);
        } else {
            $this->ChargeCode = $chargeCode;
        }
        return $this;
    }
    /**
     * Add item to ChargeCode value
     * @throws \InvalidArgumentException
     * @param \StructType\ChargeCode $item
     * @return \ArrayType\ArrayOfChargeCode
     */
    public function addToChargeCode(\StructType\ChargeCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChargeCode) {
            throw new \InvalidArgumentException(sprintf('The ChargeCode property can only contain items of type \StructType\ChargeCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChargeCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ChargeCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ChargeCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ChargeCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ChargeCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ChargeCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargeCode
     */
    public function getAttributeName()
    {
        return 'ChargeCode';
    }
}
