<?php

namespace Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaNierejestrowanaZNumeremType StructType
 * @subpackage Structs
 */
class PrzesylkaNierejestrowanaZNumeremType extends PrzesylkaRejestrowanaType
{
    /**
     * The posteRestante
     * @var bool
     */
    public $posteRestante;
    /**
     * The miejscowa
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $miejscowa;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The obszarMiasto
     * @var bool
     */
    public $obszarMiasto;
    /**
     * The kategoria
     * @var string
     */
    public $kategoria;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * The serwis
     * @var string
     */
    public $serwis;
    /**
     * Constructor method for przesylkaNierejestrowanaZNumeremType
     * @uses PrzesylkaNierejestrowanaZNumeremType::setPosteRestante()
     * @uses PrzesylkaNierejestrowanaZNumeremType::setMiejscowa()
     * @uses PrzesylkaNierejestrowanaZNumeremType::setMasa()
     * @uses PrzesylkaNierejestrowanaZNumeremType::setObszarMiasto()
     * @uses PrzesylkaNierejestrowanaZNumeremType::setKategoria()
     * @uses PrzesylkaNierejestrowanaZNumeremType::setGabaryt()
     * @uses PrzesylkaNierejestrowanaZNumeremType::setSerwis()
     * @param bool $posteRestante
     * @param bool $miejscowa
     * @param int $masa
     * @param bool $obszarMiasto
     * @param string $kategoria
     * @param string $gabaryt
     * @param string $serwis
     */
    public function __construct($posteRestante = null, $miejscowa = false, $masa = null, $obszarMiasto = null, $kategoria = null, $gabaryt = null, $serwis = null)
    {
        $this
            ->setPosteRestante($posteRestante)
            ->setMiejscowa($miejscowa)
            ->setMasa($masa)
            ->setObszarMiasto($obszarMiasto)
            ->setKategoria($kategoria)
            ->setGabaryt($gabaryt)
            ->setSerwis($serwis);
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PrzesylkaNierejestrowanaZNumeremType
     */
    public function setPosteRestante($posteRestante = null)
    {
        // validation for constraint: boolean
        if (!is_null($posteRestante) && !is_bool($posteRestante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($posteRestante, true), gettype($posteRestante)), __LINE__);
        }
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get miejscowa value
     * @return bool|null
     */
    public function getMiejscowa()
    {
        return $this->miejscowa;
    }
    /**
     * Set miejscowa value
     * @param bool $miejscowa
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PrzesylkaNierejestrowanaZNumeremType
     */
    public function setMiejscowa($miejscowa = false)
    {
        // validation for constraint: boolean
        if (!is_null($miejscowa) && !is_bool($miejscowa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($miejscowa, true), gettype($miejscowa)), __LINE__);
        }
        $this->miejscowa = $miejscowa;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PrzesylkaNierejestrowanaZNumeremType
     */
    public function setMasa($masa = null)
    {
        // validation for constraint: int
        if (!is_null($masa) && !(is_int($masa) || ctype_digit($masa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masa, true), gettype($masa)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($masa) && $masa > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($masa, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($masa) && $masa < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($masa, true)), __LINE__);
        }
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get obszarMiasto value
     * @return bool|null
     */
    public function getObszarMiasto()
    {
        return $this->obszarMiasto;
    }
    /**
     * Set obszarMiasto value
     * @param bool $obszarMiasto
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PrzesylkaNierejestrowanaZNumeremType
     */
    public function setObszarMiasto($obszarMiasto = null)
    {
        // validation for constraint: boolean
        if (!is_null($obszarMiasto) && !is_bool($obszarMiasto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($obszarMiasto, true), gettype($obszarMiasto)), __LINE__);
        }
        $this->obszarMiasto = $obszarMiasto;
        return $this;
    }
    /**
     * Get kategoria value
     * @return string|null
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\KategoriaType::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\KategoriaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kategoria
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PrzesylkaNierejestrowanaZNumeremType
     */
    public function setKategoria($kategoria = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\KategoriaType::valueIsValid($kategoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\KategoriaType', is_array($kategoria) ? implode(', ', $kategoria) : var_export($kategoria, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\KategoriaType::getValidValues())), __LINE__);
        }
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\GabarytType::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\GabarytType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gabaryt
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PrzesylkaNierejestrowanaZNumeremType
     */
    public function setGabaryt($gabaryt = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\GabarytType::valueIsValid($gabaryt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\GabarytType', is_array($gabaryt) ? implode(', ', $gabaryt) : var_export($gabaryt, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\GabarytType::getValidValues())), __LINE__);
        }
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get serwis value
     * @return string|null
     */
    public function getSerwis()
    {
        return $this->serwis;
    }
    /**
     * Set serwis value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\SerwisNierejestrowanaZNumeremType::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\SerwisNierejestrowanaZNumeremType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serwis
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PrzesylkaNierejestrowanaZNumeremType
     */
    public function setSerwis($serwis = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\SerwisNierejestrowanaZNumeremType::valueIsValid($serwis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\SerwisNierejestrowanaZNumeremType', is_array($serwis) ? implode(', ', $serwis) : var_export($serwis, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\SerwisNierejestrowanaZNumeremType::getValidValues())), __LINE__);
        }
        $this->serwis = $serwis;
        return $this;
    }
}
