<?php

namespace Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pocztex2021Type StructType
 * @subpackage Structs
 */
abstract class Pocztex2021Type extends PrzesylkaRejestrowanaType
{
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType
     */
    public $pobranie;
    /**
     * The potwierdzenieDoreczenia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieEDoreczeniaType
     */
    public $potwierdzenieDoreczenia;
    /**
     * The potwierdzenieOdbioru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieOdbioruPocztex2021Type
     */
    public $potwierdzenieOdbioru;
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - maxOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ostroznie;
    /**
     * The ponadgabaryt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ponadgabaryt;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The numerPrzesylkiKlienta
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The zwrotDokumentow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zwrotDokumentow;
    /**
     * The idDokumentyZwrotneAdresy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $idDokumentyZwrotneAdresy;
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\EPOType
     */
    public $epo;
    /**
     * The adresDlaZwrotu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdresType
     */
    public $adresDlaZwrotu;
    /**
     * The odbiorWSobote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $odbiorWSobote;
    /**
     * The zasadySpecjalne
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zasadySpecjalne;
    /**
     * The zawartosc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\ZawartoscPocztex2021Type
     */
    public $zawartosc;
    /**
     * The sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    /**
     * The uiszczaOplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uiszczaOplate;
    /**
     * The doreczenieDoRakWlasnych
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $doreczenieDoRakWlasnych;
    /**
     * Constructor method for pocztex2021Type
     * @uses Pocztex2021Type::setPobranie()
     * @uses Pocztex2021Type::setPotwierdzenieDoreczenia()
     * @uses Pocztex2021Type::setPotwierdzenieOdbioru()
     * @uses Pocztex2021Type::setUbezpieczenie()
     * @uses Pocztex2021Type::setMasa()
     * @uses Pocztex2021Type::setWartosc()
     * @uses Pocztex2021Type::setOstroznie()
     * @uses Pocztex2021Type::setPonadgabaryt()
     * @uses Pocztex2021Type::setFormat()
     * @uses Pocztex2021Type::setNumerPrzesylkiKlienta()
     * @uses Pocztex2021Type::setZwrotDokumentow()
     * @uses Pocztex2021Type::setIdDokumentyZwrotneAdresy()
     * @uses Pocztex2021Type::setEpo()
     * @uses Pocztex2021Type::setAdresDlaZwrotu()
     * @uses Pocztex2021Type::setOdbiorWSobote()
     * @uses Pocztex2021Type::setZasadySpecjalne()
     * @uses Pocztex2021Type::setZawartosc()
     * @uses Pocztex2021Type::setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
     * @uses Pocztex2021Type::setUiszczaOplate()
     * @uses Pocztex2021Type::setDoreczenieDoRakWlasnych()
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieEDoreczeniaType $potwierdzenieDoreczenia
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieOdbioruPocztex2021Type $potwierdzenieOdbioru
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie
     * @param int $masa
     * @param int $wartosc
     * @param bool $ostroznie
     * @param bool $ponadgabaryt
     * @param string $format
     * @param string $numerPrzesylkiKlienta
     * @param string $zwrotDokumentow
     * @param int $idDokumentyZwrotneAdresy
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\EPOType $epo
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdresType $adresDlaZwrotu
     * @param bool $odbiorWSobote
     * @param string $zasadySpecjalne
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\ZawartoscPocztex2021Type $zawartosc
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @param string $uiszczaOplate
     * @param bool $doreczenieDoRakWlasnych
     */
    public function __construct(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie = null, \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieEDoreczeniaType $potwierdzenieDoreczenia = null, \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieOdbioruPocztex2021Type $potwierdzenieOdbioru = null, \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie = null, $masa = null, $wartosc = null, $ostroznie = null, $ponadgabaryt = null, $format = null, $numerPrzesylkiKlienta = null, $zwrotDokumentow = null, $idDokumentyZwrotneAdresy = null, \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\EPOType $epo = null, \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdresType $adresDlaZwrotu = null, $odbiorWSobote = null, $zasadySpecjalne = null, \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\ZawartoscPocztex2021Type $zawartosc = null, $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null, $uiszczaOplate = null, $doreczenieDoRakWlasnych = null)
    {
        $this
            ->setPobranie($pobranie)
            ->setPotwierdzenieDoreczenia($potwierdzenieDoreczenia)
            ->setPotwierdzenieOdbioru($potwierdzenieOdbioru)
            ->setUbezpieczenie($ubezpieczenie)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setPonadgabaryt($ponadgabaryt)
            ->setFormat($format)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setZwrotDokumentow($zwrotDokumentow)
            ->setIdDokumentyZwrotneAdresy($idDokumentyZwrotneAdresy)
            ->setEpo($epo)
            ->setAdresDlaZwrotu($adresDlaZwrotu)
            ->setOdbiorWSobote($odbiorWSobote)
            ->setZasadySpecjalne($zasadySpecjalne)
            ->setZawartosc($zawartosc)
            ->setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce)
            ->setUiszczaOplate($uiszczaOplate)
            ->setDoreczenieDoRakWlasnych($doreczenieDoRakWlasnych);
    }
    /**
     * Get pobranie value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setPobranie(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get potwierdzenieDoreczenia value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieEDoreczeniaType|null
     */
    public function getPotwierdzenieDoreczenia()
    {
        return $this->potwierdzenieDoreczenia;
    }
    /**
     * Set potwierdzenieDoreczenia value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieEDoreczeniaType $potwierdzenieDoreczenia
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setPotwierdzenieDoreczenia(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieEDoreczeniaType $potwierdzenieDoreczenia = null)
    {
        $this->potwierdzenieDoreczenia = $potwierdzenieDoreczenia;
        return $this;
    }
    /**
     * Get potwierdzenieOdbioru value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieOdbioruPocztex2021Type|null
     */
    public function getPotwierdzenieOdbioru()
    {
        return $this->potwierdzenieOdbioru;
    }
    /**
     * Set potwierdzenieOdbioru value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieOdbioruPocztex2021Type $potwierdzenieOdbioru
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setPotwierdzenieOdbioru(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PotwierdzenieOdbioruPocztex2021Type $potwierdzenieOdbioru = null)
    {
        $this->potwierdzenieOdbioru = $potwierdzenieOdbioru;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setUbezpieczenie(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setMasa($masa = null)
    {
        // validation for constraint: int
        if (!is_null($masa) && !(is_int($masa) || ctype_digit($masa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masa, true), gettype($masa)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($masa) && $masa > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($masa, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($masa) && $masa < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($masa, true)), __LINE__);
        }
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setWartosc($wartosc = null)
    {
        // validation for constraint: int
        if (!is_null($wartosc) && !(is_int($wartosc) || ctype_digit($wartosc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wartosc, true), gettype($wartosc)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($wartosc) && $wartosc > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($wartosc, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($wartosc) && $wartosc < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($wartosc, true)), __LINE__);
        }
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setOstroznie($ostroznie = null)
    {
        // validation for constraint: boolean
        if (!is_null($ostroznie) && !is_bool($ostroznie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ostroznie, true), gettype($ostroznie)), __LINE__);
        }
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get ponadgabaryt value
     * @return bool|null
     */
    public function getPonadgabaryt()
    {
        return $this->ponadgabaryt;
    }
    /**
     * Set ponadgabaryt value
     * @param bool $ponadgabaryt
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setPonadgabaryt($ponadgabaryt = null)
    {
        // validation for constraint: boolean
        if (!is_null($ponadgabaryt) && !is_bool($ponadgabaryt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ponadgabaryt, true), gettype($ponadgabaryt)), __LINE__);
        }
        $this->ponadgabaryt = $ponadgabaryt;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        // validation for constraint: string
        if (!is_null($numerPrzesylkiKlienta) && !is_string($numerPrzesylkiKlienta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerPrzesylkiKlienta, true), gettype($numerPrzesylkiKlienta)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($numerPrzesylkiKlienta) && mb_strlen($numerPrzesylkiKlienta) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($numerPrzesylkiKlienta)), __LINE__);
        }
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get zwrotDokumentow value
     * @return string|null
     */
    public function getZwrotDokumentow()
    {
        return $this->zwrotDokumentow;
    }
    /**
     * Set zwrotDokumentow value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZwrotDokumentowPocztex2021Enum::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZwrotDokumentowPocztex2021Enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zwrotDokumentow
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setZwrotDokumentow($zwrotDokumentow = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZwrotDokumentowPocztex2021Enum::valueIsValid($zwrotDokumentow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZwrotDokumentowPocztex2021Enum', is_array($zwrotDokumentow) ? implode(', ', $zwrotDokumentow) : var_export($zwrotDokumentow, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZwrotDokumentowPocztex2021Enum::getValidValues())), __LINE__);
        }
        $this->zwrotDokumentow = $zwrotDokumentow;
        return $this;
    }
    /**
     * Get idDokumentyZwrotneAdresy value
     * @return int|null
     */
    public function getIdDokumentyZwrotneAdresy()
    {
        return $this->idDokumentyZwrotneAdresy;
    }
    /**
     * Set idDokumentyZwrotneAdresy value
     * @param int $idDokumentyZwrotneAdresy
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setIdDokumentyZwrotneAdresy($idDokumentyZwrotneAdresy = null)
    {
        // validation for constraint: int
        if (!is_null($idDokumentyZwrotneAdresy) && !(is_int($idDokumentyZwrotneAdresy) || ctype_digit($idDokumentyZwrotneAdresy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idDokumentyZwrotneAdresy, true), gettype($idDokumentyZwrotneAdresy)), __LINE__);
        }
        $this->idDokumentyZwrotneAdresy = $idDokumentyZwrotneAdresy;
        return $this;
    }
    /**
     * Get epo value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\EPOType $epo
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setEpo(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get adresDlaZwrotu value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdresType|null
     */
    public function getAdresDlaZwrotu()
    {
        return $this->adresDlaZwrotu;
    }
    /**
     * Set adresDlaZwrotu value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdresType $adresDlaZwrotu
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setAdresDlaZwrotu(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdresType $adresDlaZwrotu = null)
    {
        $this->adresDlaZwrotu = $adresDlaZwrotu;
        return $this;
    }
    /**
     * Get odbiorWSobote value
     * @return bool|null
     */
    public function getOdbiorWSobote()
    {
        return $this->odbiorWSobote;
    }
    /**
     * Set odbiorWSobote value
     * @param bool $odbiorWSobote
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setOdbiorWSobote($odbiorWSobote = null)
    {
        // validation for constraint: boolean
        if (!is_null($odbiorWSobote) && !is_bool($odbiorWSobote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($odbiorWSobote, true), gettype($odbiorWSobote)), __LINE__);
        }
        $this->odbiorWSobote = $odbiorWSobote;
        return $this;
    }
    /**
     * Get zasadySpecjalne value
     * @return string|null
     */
    public function getZasadySpecjalne()
    {
        return $this->zasadySpecjalne;
    }
    /**
     * Set zasadySpecjalne value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZasadySpecjalneEnum::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZasadySpecjalneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zasadySpecjalne
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setZasadySpecjalne($zasadySpecjalne = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZasadySpecjalneEnum::valueIsValid($zasadySpecjalne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZasadySpecjalneEnum', is_array($zasadySpecjalne) ? implode(', ', $zasadySpecjalne) : var_export($zasadySpecjalne, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\ZasadySpecjalneEnum::getValidValues())), __LINE__);
        }
        $this->zasadySpecjalne = $zasadySpecjalne;
        return $this;
    }
    /**
     * Get zawartosc value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\ZawartoscPocztex2021Type|null
     */
    public function getZawartosc()
    {
        return $this->zawartosc;
    }
    /**
     * Set zawartosc value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\ZawartoscPocztex2021Type $zawartosc
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setZawartosc(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\ZawartoscPocztex2021Type $zawartosc = null)
    {
        $this->zawartosc = $zawartosc;
        return $this;
    }
    /**
     * Get sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @return bool|null
     */
    public function getSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
    {
        return $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    }
    /**
     * Set sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null)
    {
        // validation for constraint: boolean
        if (!is_null($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce) && !is_bool($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce, true), gettype($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce)), __LINE__);
        }
        $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
        return $this;
    }
    /**
     * Get uiszczaOplate value
     * @return string|null
     */
    public function getUiszczaOplate()
    {
        return $this->uiszczaOplate;
    }
    /**
     * Set uiszczaOplate value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\UiszczaOplateType::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\UiszczaOplateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uiszczaOplate
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setUiszczaOplate($uiszczaOplate = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\UiszczaOplateType::valueIsValid($uiszczaOplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\UiszczaOplateType', is_array($uiszczaOplate) ? implode(', ', $uiszczaOplate) : var_export($uiszczaOplate, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\UiszczaOplateType::getValidValues())), __LINE__);
        }
        $this->uiszczaOplate = $uiszczaOplate;
        return $this;
    }
    /**
     * Get doreczenieDoRakWlasnych value
     * @return bool|null
     */
    public function getDoreczenieDoRakWlasnych()
    {
        return $this->doreczenieDoRakWlasnych;
    }
    /**
     * Set doreczenieDoRakWlasnych value
     * @param bool $doreczenieDoRakWlasnych
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\Pocztex2021Type
     */
    public function setDoreczenieDoRakWlasnych($doreczenieDoRakWlasnych = null)
    {
        // validation for constraint: boolean
        if (!is_null($doreczenieDoRakWlasnych) && !is_bool($doreczenieDoRakWlasnych)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doreczenieDoRakWlasnych, true), gettype($doreczenieDoRakWlasnych)), __LINE__);
        }
        $this->doreczenieDoRakWlasnych = $doreczenieDoRakWlasnych;
        return $this;
    }
}
