<?php

namespace Polkurier\Core\Courier\PocztexBase\API\API_WSDL\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SendEnvelope $parameters
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SendEnvelopeResponseType|bool
     */
    public function sendEnvelope(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SendEnvelope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SendEnvelopeResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
