<?php

namespace Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEPOStatus StructType
 * @subpackage Structs
 */
class GetEPOStatus extends AbstractStructBase
{
    /**
     * The guid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - maxOccurs: 500
     * - minOccurs: 1
     * - whiteSpace: collapse
     * @var string[]
     */
    public $guid;
    /**
     * The endedOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $endedOnly;
    /**
     * The idEnvelope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $idEnvelope;
    /**
     * The withBioepo
     * Meta information extracted from the WSDL
     * - documentation: Element służy do przekazania żądania uzupełnienia statusu EPO dla wskazanych przesyłek o dane dotyczące podpisu odbiorcy przesyłki. W zalezności od urządzenia wykorzystanego do utrwalenia podpisu, w odpowiedzi na wywołanie
     * metody może zostać zwrócony sam obraz podpisu lub obraz podpisu uzupełniony o jego dane biometryczne.
     * @var bool
     */
    public $withBioepo;
    /**
     * Constructor method for getEPOStatus
     * @uses GetEPOStatus::setGuid()
     * @uses GetEPOStatus::setEndedOnly()
     * @uses GetEPOStatus::setIdEnvelope()
     * @uses GetEPOStatus::setWithBioepo()
     * @param string[] $guid
     * @param bool $endedOnly
     * @param int $idEnvelope
     * @param bool $withBioepo
     */
    public function __construct(array $guid = array(), $endedOnly = null, $idEnvelope = null, $withBioepo = null)
    {
        $this
            ->setGuid($guid)
            ->setEndedOnly($endedOnly)
            ->setIdEnvelope($idEnvelope)
            ->setWithBioepo($withBioepo);
    }
    /**
     * Get guid value
     * @return string[]
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * This method is responsible for validating the values passed to the setGuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuidForArrayConstraintsFromSetGuid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getEPOStatusGuidItem) {
            // validation for constraint: itemType
            if (!is_string($getEPOStatusGuidItem)) {
                $invalidValues[] = is_object($getEPOStatusGuidItem) ? get_class($getEPOStatusGuidItem) : sprintf('%s(%s)', gettype($getEPOStatusGuidItem), var_export($getEPOStatusGuidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The guid property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuid method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuidForLengthConstraintFromSetGuid($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getEPOStatusGuidItem) {
            // validation for constraint: length(32)
            if (mb_strlen($getEPOStatusGuidItem) !== 32) {
                $invalidValues[] = var_export($getEPOStatusGuidItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 32', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set guid value
     * @throws \InvalidArgumentException
     * @param string[] $guid
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\GetEPOStatus
     */
    public function setGuid(array $guid = array())
    {
        // validation for constraint: array
        if ('' !== ($guidArrayErrorMessage = self::validateGuidForArrayConstraintsFromSetGuid($guid))) {
            throw new \InvalidArgumentException($guidArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(32)
        if ('' !== ($guidLengthErrorMessage = self::validateGuidForLengthConstraintFromSetGuid($guid))) {
            throw new \InvalidArgumentException($guidLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(500)
        if (is_array($guid) && count($guid) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 500', count($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Add item to guid value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\GetEPOStatus
     */
    public function addToGuid($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The guid property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(32)
        if (mb_strlen($item) !== 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 32', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(500)
        if (is_array($this->guid) && count($this->guid) >= 500) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 500', count($this->guid)), __LINE__);
        }
        $this->guid[] = $item;
        return $this;
    }
    /**
     * Get endedOnly value
     * @return bool
     */
    public function getEndedOnly()
    {
        return $this->endedOnly;
    }
    /**
     * Set endedOnly value
     * @param bool $endedOnly
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\GetEPOStatus
     */
    public function setEndedOnly($endedOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($endedOnly) && !is_bool($endedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($endedOnly, true), gettype($endedOnly)), __LINE__);
        }
        $this->endedOnly = $endedOnly;
        return $this;
    }
    /**
     * Get idEnvelope value
     * @return int
     */
    public function getIdEnvelope()
    {
        return $this->idEnvelope;
    }
    /**
     * Set idEnvelope value
     * @param int $idEnvelope
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\GetEPOStatus
     */
    public function setIdEnvelope($idEnvelope = null)
    {
        // validation for constraint: int
        if (!is_null($idEnvelope) && !(is_int($idEnvelope) || ctype_digit($idEnvelope))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idEnvelope, true), gettype($idEnvelope)), __LINE__);
        }
        $this->idEnvelope = $idEnvelope;
        return $this;
    }
    /**
     * Get withBioepo value
     * @return bool|null
     */
    public function getWithBioepo()
    {
        return $this->withBioepo;
    }
    /**
     * Set withBioepo value
     * @param bool $withBioepo
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\GetEPOStatus
     */
    public function setWithBioepo($withBioepo = null)
    {
        // validation for constraint: boolean
        if (!is_null($withBioepo) && !is_bool($withBioepo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withBioepo, true), gettype($withBioepo)), __LINE__);
        }
        $this->withBioepo = $withBioepo;
        return $this;
    }
}
