<?php

namespace Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subPocztex2021Type StructType
 * @subpackage Structs
 */
abstract class SubPocztex2021Type extends PrzesylkaType
{
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType
     */
    public $pobranie;
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $numerNadania;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - maxOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ostroznie;
    /**
     * The ponadgabaryt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ponadgabaryt;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The numerPrzesylkiKlienta
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * Constructor method for subPocztex2021Type
     * @uses SubPocztex2021Type::setPobranie()
     * @uses SubPocztex2021Type::setUbezpieczenie()
     * @uses SubPocztex2021Type::setNumerNadania()
     * @uses SubPocztex2021Type::setMasa()
     * @uses SubPocztex2021Type::setWartosc()
     * @uses SubPocztex2021Type::setOstroznie()
     * @uses SubPocztex2021Type::setPonadgabaryt()
     * @uses SubPocztex2021Type::setFormat()
     * @uses SubPocztex2021Type::setNumerPrzesylkiKlienta()
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie
     * @param string $numerNadania
     * @param int $masa
     * @param int $wartosc
     * @param bool $ostroznie
     * @param bool $ponadgabaryt
     * @param string $format
     * @param string $numerPrzesylkiKlienta
     */
    public function __construct(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie = null, \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie = null, $numerNadania = null, $masa = null, $wartosc = null, $ostroznie = null, $ponadgabaryt = null, $format = null, $numerPrzesylkiKlienta = null)
    {
        $this
            ->setPobranie($pobranie)
            ->setUbezpieczenie($ubezpieczenie)
            ->setNumerNadania($numerNadania)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setPonadgabaryt($ponadgabaryt)
            ->setFormat($format)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta);
    }
    /**
     * Get pobranie value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setPobranie(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setUbezpieczenie(\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setNumerNadania($numerNadania = null)
    {
        // validation for constraint: string
        if (!is_null($numerNadania) && !is_string($numerNadania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerNadania, true), gettype($numerNadania)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($numerNadania) && mb_strlen($numerNadania) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($numerNadania)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($numerNadania) && mb_strlen($numerNadania) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($numerNadania)), __LINE__);
        }
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setMasa($masa = null)
    {
        // validation for constraint: int
        if (!is_null($masa) && !(is_int($masa) || ctype_digit($masa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masa, true), gettype($masa)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($masa) && $masa > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($masa, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($masa) && $masa < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($masa, true)), __LINE__);
        }
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setWartosc($wartosc = null)
    {
        // validation for constraint: int
        if (!is_null($wartosc) && !(is_int($wartosc) || ctype_digit($wartosc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wartosc, true), gettype($wartosc)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($wartosc) && $wartosc > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($wartosc, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($wartosc) && $wartosc < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($wartosc, true)), __LINE__);
        }
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setOstroznie($ostroznie = null)
    {
        // validation for constraint: boolean
        if (!is_null($ostroznie) && !is_bool($ostroznie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ostroznie, true), gettype($ostroznie)), __LINE__);
        }
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get ponadgabaryt value
     * @return bool|null
     */
    public function getPonadgabaryt()
    {
        return $this->ponadgabaryt;
    }
    /**
     * Set ponadgabaryt value
     * @param bool $ponadgabaryt
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setPonadgabaryt($ponadgabaryt = null)
    {
        // validation for constraint: boolean
        if (!is_null($ponadgabaryt) && !is_bool($ponadgabaryt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ponadgabaryt, true), gettype($ponadgabaryt)), __LINE__);
        }
        $this->ponadgabaryt = $ponadgabaryt;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::valueIsValid()
     * @uses \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\EnumType\FormatPocztex2021Type::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\SubPocztex2021Type
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        // validation for constraint: string
        if (!is_null($numerPrzesylkiKlienta) && !is_string($numerPrzesylkiKlienta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerPrzesylkiKlienta, true), gettype($numerPrzesylkiKlienta)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($numerPrzesylkiKlienta) && mb_strlen($numerPrzesylkiKlienta) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($numerPrzesylkiKlienta)), __LINE__);
        }
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
}
