<?php

namespace Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for additionalActivityType StructType
 * Meta information extracted from the WSDL
 * - documentation: Czynność do wykonania w ramach np. przesyłki proceduralnej
 * @subpackage Structs
 */
class AdditionalActivityType extends AbstractStructBase
{
    /**
     * The idActivity
     * Meta information extracted from the WSDL
     * - documentation: identyfikator czynności
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $idActivity;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Nazwa czynności do wykonania | Ciąg znaków długości 127 znaków
     * - base: xsd:string
     * - maxLength: 127
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: opis czynności do wykonania | Ciąg znaków długości 1023 znaków
     * - base: xsd:string
     * - maxLength: 1023
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The critical
     * Meta information extracted from the WSDL
     * - documentation: znacznik czy czynnośc jest krytyczna. brak wykonania czynności oznaczonej jako krytyczna przerywa proces doręczenia.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $critical;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - documentation: Element określa kolejność dla czynności do wykonania w sekwecji czynności.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $order;
    /**
     * The validFrom
     * Meta information extracted from the WSDL
     * - documentation: Termin ważności, należy podać datę od kiedy dana czynność jest dostępna, liczone jest od godziny 0:00:00.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $validFrom;
    /**
     * The validTo
     * Meta information extracted from the WSDL
     * - documentation: Termin ważności, należy podać datę do kiedy dana czynność jest dostępna, liczone jest do godziny 23:59:59.999
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $validTo;
    /**
     * Constructor method for additionalActivityType
     * @uses AdditionalActivityType::setIdActivity()
     * @uses AdditionalActivityType::setName()
     * @uses AdditionalActivityType::setDescription()
     * @uses AdditionalActivityType::setCritical()
     * @uses AdditionalActivityType::setOrder()
     * @uses AdditionalActivityType::setValidFrom()
     * @uses AdditionalActivityType::setValidTo()
     * @param int $idActivity
     * @param string $name
     * @param string $description
     * @param bool $critical
     * @param int $order
     * @param string $validFrom
     * @param string $validTo
     */
    public function __construct($idActivity = null, $name = null, $description = null, $critical = null, $order = null, $validFrom = null, $validTo = null)
    {
        $this
            ->setIdActivity($idActivity)
            ->setName($name)
            ->setDescription($description)
            ->setCritical($critical)
            ->setOrder($order)
            ->setValidFrom($validFrom)
            ->setValidTo($validTo);
    }
    /**
     * Get idActivity value
     * @return int|null
     */
    public function getIdActivity()
    {
        return $this->idActivity;
    }
    /**
     * Set idActivity value
     * @param int $idActivity
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdditionalActivityType
     */
    public function setIdActivity($idActivity = null)
    {
        // validation for constraint: int
        if (!is_null($idActivity) && !(is_int($idActivity) || ctype_digit($idActivity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idActivity, true), gettype($idActivity)), __LINE__);
        }
        $this->idActivity = $idActivity;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdditionalActivityType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(127)
        if (!is_null($name) && mb_strlen($name) > 127) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 127', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdditionalActivityType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(1023)
        if (!is_null($description) && mb_strlen($description) > 1023) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1023', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get critical value
     * @return bool|null
     */
    public function getCritical()
    {
        return $this->critical;
    }
    /**
     * Set critical value
     * @param bool $critical
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdditionalActivityType
     */
    public function setCritical($critical = null)
    {
        // validation for constraint: boolean
        if (!is_null($critical) && !is_bool($critical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($critical, true), gettype($critical)), __LINE__);
        }
        $this->critical = $critical;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdditionalActivityType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get validFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->validFrom;
    }
    /**
     * Set validFrom value
     * @param string $validFrom
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdditionalActivityType
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->validFrom = $validFrom;
        return $this;
    }
    /**
     * Get validTo value
     * @return string|null
     */
    public function getValidTo()
    {
        return $this->validTo;
    }
    /**
     * Set validTo value
     * @param string $validTo
     * @return \Polkurier\Core\Courier\PocztexBase\API\API_WSDL\StructType\AdditionalActivityType
     */
    public function setValidTo($validTo = null)
    {
        // validation for constraint: string
        if (!is_null($validTo) && !is_string($validTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validTo, true), gettype($validTo)), __LINE__);
        }
        $this->validTo = $validTo;
        return $this;
    }
}
