<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TSgkInvoiceInfo StructType
 * @subpackage Structs
 */
class TSgkInvoiceInfo extends AbstractStructBase
{
    /**
     * The AdditionalInvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalInvoiceType;
    /**
     * The TaxpayerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxpayerCode;
    /**
     * The TaxpayerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxpayerName;
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNumber;
    /**
     * The PeriodStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PeriodEndDate;
    /**
     * Constructor method for TSgkInvoiceInfo
     * @uses TSgkInvoiceInfo::setAdditionalInvoiceType()
     * @uses TSgkInvoiceInfo::setTaxpayerCode()
     * @uses TSgkInvoiceInfo::setTaxpayerName()
     * @uses TSgkInvoiceInfo::setDocumentNumber()
     * @uses TSgkInvoiceInfo::setPeriodStartDate()
     * @uses TSgkInvoiceInfo::setPeriodEndDate()
     * @param string $additionalInvoiceType
     * @param string $taxpayerCode
     * @param string $taxpayerName
     * @param string $documentNumber
     * @param string $periodStartDate
     * @param string $periodEndDate
     */
    public function __construct($additionalInvoiceType = null, $taxpayerCode = null, $taxpayerName = null, $documentNumber = null, $periodStartDate = null, $periodEndDate = null)
    {
        $this
            ->setAdditionalInvoiceType($additionalInvoiceType)
            ->setTaxpayerCode($taxpayerCode)
            ->setTaxpayerName($taxpayerName)
            ->setDocumentNumber($documentNumber)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate);
    }
    /**
     * Get AdditionalInvoiceType value
     * @return string|null
     */
    public function getAdditionalInvoiceType()
    {
        return $this->AdditionalInvoiceType;
    }
    /**
     * Set AdditionalInvoiceType value
     * @param string $additionalInvoiceType
     * @return \StructType\TSgkInvoiceInfo
     */
    public function setAdditionalInvoiceType($additionalInvoiceType = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInvoiceType) && !is_string($additionalInvoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInvoiceType, true), gettype($additionalInvoiceType)), __LINE__);
        }
        $this->AdditionalInvoiceType = $additionalInvoiceType;
        return $this;
    }
    /**
     * Get TaxpayerCode value
     * @return string|null
     */
    public function getTaxpayerCode()
    {
        return $this->TaxpayerCode;
    }
    /**
     * Set TaxpayerCode value
     * @param string $taxpayerCode
     * @return \StructType\TSgkInvoiceInfo
     */
    public function setTaxpayerCode($taxpayerCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxpayerCode) && !is_string($taxpayerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxpayerCode, true), gettype($taxpayerCode)), __LINE__);
        }
        $this->TaxpayerCode = $taxpayerCode;
        return $this;
    }
    /**
     * Get TaxpayerName value
     * @return string|null
     */
    public function getTaxpayerName()
    {
        return $this->TaxpayerName;
    }
    /**
     * Set TaxpayerName value
     * @param string $taxpayerName
     * @return \StructType\TSgkInvoiceInfo
     */
    public function setTaxpayerName($taxpayerName = null)
    {
        // validation for constraint: string
        if (!is_null($taxpayerName) && !is_string($taxpayerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxpayerName, true), gettype($taxpayerName)), __LINE__);
        }
        $this->TaxpayerName = $taxpayerName;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \StructType\TSgkInvoiceInfo
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string|null
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \StructType\TSgkInvoiceInfo
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodStartDate, true), gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string|null
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \StructType\TSgkInvoiceInfo
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodEndDate, true), gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
}
