<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TReturnStatus StructType
 * @subpackage Structs
 */
class TReturnStatus extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Details;
    /**
     * Constructor method for TReturnStatus
     * @uses TReturnStatus::setStatus()
     * @uses TReturnStatus::setMessage()
     * @uses TReturnStatus::setDetails()
     * @param bool $status
     * @param string $message
     * @param \ArrayType\ArrayOfString $details
     */
    public function __construct($status = null, $message = null, \ArrayType\ArrayOfString $details = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setDetails($details);
    }
    /**
     * Get Status value
     * @return bool
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\TReturnStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\TReturnStatus
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfString $details
     * @return \StructType\TReturnStatus
     */
    public function setDetails(\ArrayType\ArrayOfString $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
