<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TInvoiceLine StructType
 * @subpackage Structs
 */
class TInvoiceLine extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The InvoicedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InvoicedQuantity;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The TaxTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotalAmount;
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LineExtensionAmount;
    /**
     * The AllowanceCharge1Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge1Amount;
    /**
     * The AllowanceCharge1Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge1Percent;
    /**
     * The AllowanceCharge2Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge2Amount;
    /**
     * The AllowanceCharge2Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge2Percent;
    /**
     * The AllowanceCharge3Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge3Amount;
    /**
     * The AllowanceCharge3Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge3Percent;
    /**
     * The AllowanceCharge4Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge4Amount;
    /**
     * The AllowanceCharge4Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceCharge4Percent;
    /**
     * The HasWithholdingTax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasWithholdingTax;
    /**
     * The StockCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StockCode;
    /**
     * The StockName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StockName;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModelName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IsoUnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsoUnitCode;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTTaxTotal
     */
    public $TaxTotal;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyID;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TDeliveryType
     */
    public $Delivery;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TTaxTotal
     */
    public $WithholdingTaxTotal;
    /**
     * The OriginCountryIdentificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginCountryIdentificationCode;
    /**
     * The OriginCountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginCountryName;
    /**
     * The ClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassificationCode;
    /**
     * The ClassificationListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassificationListName;
    /**
     * The ClassificationListVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassificationListVersionID;
    /**
     * The ManufacturersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturersItemIdentification;
    /**
     * Constructor method for TInvoiceLine
     * @uses TInvoiceLine::setID()
     * @uses TInvoiceLine::setInvoicedQuantity()
     * @uses TInvoiceLine::setPrice()
     * @uses TInvoiceLine::setTaxTotalAmount()
     * @uses TInvoiceLine::setLineExtensionAmount()
     * @uses TInvoiceLine::setAllowanceCharge1Amount()
     * @uses TInvoiceLine::setAllowanceCharge1Percent()
     * @uses TInvoiceLine::setAllowanceCharge2Amount()
     * @uses TInvoiceLine::setAllowanceCharge2Percent()
     * @uses TInvoiceLine::setAllowanceCharge3Amount()
     * @uses TInvoiceLine::setAllowanceCharge3Percent()
     * @uses TInvoiceLine::setAllowanceCharge4Amount()
     * @uses TInvoiceLine::setAllowanceCharge4Percent()
     * @uses TInvoiceLine::setHasWithholdingTax()
     * @uses TInvoiceLine::setStockCode()
     * @uses TInvoiceLine::setStockName()
     * @uses TInvoiceLine::setBrandName()
     * @uses TInvoiceLine::setModelName()
     * @uses TInvoiceLine::setDescription()
     * @uses TInvoiceLine::setIsoUnitCode()
     * @uses TInvoiceLine::setTaxTotal()
     * @uses TInvoiceLine::setCurrencyID()
     * @uses TInvoiceLine::setDelivery()
     * @uses TInvoiceLine::setWithholdingTaxTotal()
     * @uses TInvoiceLine::setOriginCountryIdentificationCode()
     * @uses TInvoiceLine::setOriginCountryName()
     * @uses TInvoiceLine::setClassificationCode()
     * @uses TInvoiceLine::setClassificationListName()
     * @uses TInvoiceLine::setClassificationListVersionID()
     * @uses TInvoiceLine::setManufacturersItemIdentification()
     * @param int $iD
     * @param float $invoicedQuantity
     * @param float $price
     * @param float $taxTotalAmount
     * @param float $lineExtensionAmount
     * @param float $allowanceCharge1Amount
     * @param float $allowanceCharge1Percent
     * @param float $allowanceCharge2Amount
     * @param float $allowanceCharge2Percent
     * @param float $allowanceCharge3Amount
     * @param float $allowanceCharge3Percent
     * @param float $allowanceCharge4Amount
     * @param float $allowanceCharge4Percent
     * @param bool $hasWithholdingTax
     * @param string $stockCode
     * @param string $stockName
     * @param string $brandName
     * @param string $modelName
     * @param string $description
     * @param string $isoUnitCode
     * @param \ArrayType\ArrayOfTTaxTotal $taxTotal
     * @param string $currencyID
     * @param \StructType\TDeliveryType $delivery
     * @param \StructType\TTaxTotal $withholdingTaxTotal
     * @param string $originCountryIdentificationCode
     * @param string $originCountryName
     * @param string $classificationCode
     * @param string $classificationListName
     * @param string $classificationListVersionID
     * @param string $manufacturersItemIdentification
     */
    public function __construct($iD = null, $invoicedQuantity = null, $price = null, $taxTotalAmount = null, $lineExtensionAmount = null, $allowanceCharge1Amount = null, $allowanceCharge1Percent = null, $allowanceCharge2Amount = null, $allowanceCharge2Percent = null, $allowanceCharge3Amount = null, $allowanceCharge3Percent = null, $allowanceCharge4Amount = null, $allowanceCharge4Percent = null, $hasWithholdingTax = null, $stockCode = null, $stockName = null, $brandName = null, $modelName = null, $description = null, $isoUnitCode = null, \ArrayType\ArrayOfTTaxTotal $taxTotal = null, $currencyID = null, \StructType\TDeliveryType $delivery = null, \StructType\TTaxTotal $withholdingTaxTotal = null, $originCountryIdentificationCode = null, $originCountryName = null, $classificationCode = null, $classificationListName = null, $classificationListVersionID = null, $manufacturersItemIdentification = null)
    {
        $this
            ->setID($iD)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setPrice($price)
            ->setTaxTotalAmount($taxTotalAmount)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setAllowanceCharge1Amount($allowanceCharge1Amount)
            ->setAllowanceCharge1Percent($allowanceCharge1Percent)
            ->setAllowanceCharge2Amount($allowanceCharge2Amount)
            ->setAllowanceCharge2Percent($allowanceCharge2Percent)
            ->setAllowanceCharge3Amount($allowanceCharge3Amount)
            ->setAllowanceCharge3Percent($allowanceCharge3Percent)
            ->setAllowanceCharge4Amount($allowanceCharge4Amount)
            ->setAllowanceCharge4Percent($allowanceCharge4Percent)
            ->setHasWithholdingTax($hasWithholdingTax)
            ->setStockCode($stockCode)
            ->setStockName($stockName)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setDescription($description)
            ->setIsoUnitCode($isoUnitCode)
            ->setTaxTotal($taxTotal)
            ->setCurrencyID($currencyID)
            ->setDelivery($delivery)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setOriginCountryIdentificationCode($originCountryIdentificationCode)
            ->setOriginCountryName($originCountryName)
            ->setClassificationCode($classificationCode)
            ->setClassificationListName($classificationListName)
            ->setClassificationListVersionID($classificationListVersionID)
            ->setManufacturersItemIdentification($manufacturersItemIdentification);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TInvoiceLine
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get InvoicedQuantity value
     * @return float
     */
    public function getInvoicedQuantity()
    {
        return $this->InvoicedQuantity;
    }
    /**
     * Set InvoicedQuantity value
     * @param float $invoicedQuantity
     * @return \StructType\TInvoiceLine
     */
    public function setInvoicedQuantity($invoicedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($invoicedQuantity) && !(is_float($invoicedQuantity) || is_numeric($invoicedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoicedQuantity, true), gettype($invoicedQuantity)), __LINE__);
        }
        $this->InvoicedQuantity = $invoicedQuantity;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\TInvoiceLine
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get TaxTotalAmount value
     * @return float
     */
    public function getTaxTotalAmount()
    {
        return $this->TaxTotalAmount;
    }
    /**
     * Set TaxTotalAmount value
     * @param float $taxTotalAmount
     * @return \StructType\TInvoiceLine
     */
    public function setTaxTotalAmount($taxTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotalAmount) && !(is_float($taxTotalAmount) || is_numeric($taxTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotalAmount, true), gettype($taxTotalAmount)), __LINE__);
        }
        $this->TaxTotalAmount = $taxTotalAmount;
        return $this;
    }
    /**
     * Get LineExtensionAmount value
     * @return float
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param float $lineExtensionAmount
     * @return \StructType\TInvoiceLine
     */
    public function setLineExtensionAmount($lineExtensionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($lineExtensionAmount) && !(is_float($lineExtensionAmount) || is_numeric($lineExtensionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lineExtensionAmount, true), gettype($lineExtensionAmount)), __LINE__);
        }
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get AllowanceCharge1Amount value
     * @return float
     */
    public function getAllowanceCharge1Amount()
    {
        return $this->AllowanceCharge1Amount;
    }
    /**
     * Set AllowanceCharge1Amount value
     * @param float $allowanceCharge1Amount
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge1Amount($allowanceCharge1Amount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge1Amount) && !(is_float($allowanceCharge1Amount) || is_numeric($allowanceCharge1Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge1Amount, true), gettype($allowanceCharge1Amount)), __LINE__);
        }
        $this->AllowanceCharge1Amount = $allowanceCharge1Amount;
        return $this;
    }
    /**
     * Get AllowanceCharge1Percent value
     * @return float
     */
    public function getAllowanceCharge1Percent()
    {
        return $this->AllowanceCharge1Percent;
    }
    /**
     * Set AllowanceCharge1Percent value
     * @param float $allowanceCharge1Percent
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge1Percent($allowanceCharge1Percent = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge1Percent) && !(is_float($allowanceCharge1Percent) || is_numeric($allowanceCharge1Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge1Percent, true), gettype($allowanceCharge1Percent)), __LINE__);
        }
        $this->AllowanceCharge1Percent = $allowanceCharge1Percent;
        return $this;
    }
    /**
     * Get AllowanceCharge2Amount value
     * @return float
     */
    public function getAllowanceCharge2Amount()
    {
        return $this->AllowanceCharge2Amount;
    }
    /**
     * Set AllowanceCharge2Amount value
     * @param float $allowanceCharge2Amount
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge2Amount($allowanceCharge2Amount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge2Amount) && !(is_float($allowanceCharge2Amount) || is_numeric($allowanceCharge2Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge2Amount, true), gettype($allowanceCharge2Amount)), __LINE__);
        }
        $this->AllowanceCharge2Amount = $allowanceCharge2Amount;
        return $this;
    }
    /**
     * Get AllowanceCharge2Percent value
     * @return float
     */
    public function getAllowanceCharge2Percent()
    {
        return $this->AllowanceCharge2Percent;
    }
    /**
     * Set AllowanceCharge2Percent value
     * @param float $allowanceCharge2Percent
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge2Percent($allowanceCharge2Percent = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge2Percent) && !(is_float($allowanceCharge2Percent) || is_numeric($allowanceCharge2Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge2Percent, true), gettype($allowanceCharge2Percent)), __LINE__);
        }
        $this->AllowanceCharge2Percent = $allowanceCharge2Percent;
        return $this;
    }
    /**
     * Get AllowanceCharge3Amount value
     * @return float
     */
    public function getAllowanceCharge3Amount()
    {
        return $this->AllowanceCharge3Amount;
    }
    /**
     * Set AllowanceCharge3Amount value
     * @param float $allowanceCharge3Amount
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge3Amount($allowanceCharge3Amount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge3Amount) && !(is_float($allowanceCharge3Amount) || is_numeric($allowanceCharge3Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge3Amount, true), gettype($allowanceCharge3Amount)), __LINE__);
        }
        $this->AllowanceCharge3Amount = $allowanceCharge3Amount;
        return $this;
    }
    /**
     * Get AllowanceCharge3Percent value
     * @return float
     */
    public function getAllowanceCharge3Percent()
    {
        return $this->AllowanceCharge3Percent;
    }
    /**
     * Set AllowanceCharge3Percent value
     * @param float $allowanceCharge3Percent
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge3Percent($allowanceCharge3Percent = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge3Percent) && !(is_float($allowanceCharge3Percent) || is_numeric($allowanceCharge3Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge3Percent, true), gettype($allowanceCharge3Percent)), __LINE__);
        }
        $this->AllowanceCharge3Percent = $allowanceCharge3Percent;
        return $this;
    }
    /**
     * Get AllowanceCharge4Amount value
     * @return float
     */
    public function getAllowanceCharge4Amount()
    {
        return $this->AllowanceCharge4Amount;
    }
    /**
     * Set AllowanceCharge4Amount value
     * @param float $allowanceCharge4Amount
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge4Amount($allowanceCharge4Amount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge4Amount) && !(is_float($allowanceCharge4Amount) || is_numeric($allowanceCharge4Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge4Amount, true), gettype($allowanceCharge4Amount)), __LINE__);
        }
        $this->AllowanceCharge4Amount = $allowanceCharge4Amount;
        return $this;
    }
    /**
     * Get AllowanceCharge4Percent value
     * @return float
     */
    public function getAllowanceCharge4Percent()
    {
        return $this->AllowanceCharge4Percent;
    }
    /**
     * Set AllowanceCharge4Percent value
     * @param float $allowanceCharge4Percent
     * @return \StructType\TInvoiceLine
     */
    public function setAllowanceCharge4Percent($allowanceCharge4Percent = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceCharge4Percent) && !(is_float($allowanceCharge4Percent) || is_numeric($allowanceCharge4Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceCharge4Percent, true), gettype($allowanceCharge4Percent)), __LINE__);
        }
        $this->AllowanceCharge4Percent = $allowanceCharge4Percent;
        return $this;
    }
    /**
     * Get HasWithholdingTax value
     * @return bool
     */
    public function getHasWithholdingTax()
    {
        return $this->HasWithholdingTax;
    }
    /**
     * Set HasWithholdingTax value
     * @param bool $hasWithholdingTax
     * @return \StructType\TInvoiceLine
     */
    public function setHasWithholdingTax($hasWithholdingTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasWithholdingTax) && !is_bool($hasWithholdingTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasWithholdingTax, true), gettype($hasWithholdingTax)), __LINE__);
        }
        $this->HasWithholdingTax = $hasWithholdingTax;
        return $this;
    }
    /**
     * Get StockCode value
     * @return string|null
     */
    public function getStockCode()
    {
        return $this->StockCode;
    }
    /**
     * Set StockCode value
     * @param string $stockCode
     * @return \StructType\TInvoiceLine
     */
    public function setStockCode($stockCode = null)
    {
        // validation for constraint: string
        if (!is_null($stockCode) && !is_string($stockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockCode, true), gettype($stockCode)), __LINE__);
        }
        $this->StockCode = $stockCode;
        return $this;
    }
    /**
     * Get StockName value
     * @return string|null
     */
    public function getStockName()
    {
        return $this->StockName;
    }
    /**
     * Set StockName value
     * @param string $stockName
     * @return \StructType\TInvoiceLine
     */
    public function setStockName($stockName = null)
    {
        // validation for constraint: string
        if (!is_null($stockName) && !is_string($stockName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockName, true), gettype($stockName)), __LINE__);
        }
        $this->StockName = $stockName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\TInvoiceLine
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \StructType\TInvoiceLine
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelName, true), gettype($modelName)), __LINE__);
        }
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\TInvoiceLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IsoUnitCode value
     * @return string|null
     */
    public function getIsoUnitCode()
    {
        return $this->IsoUnitCode;
    }
    /**
     * Set IsoUnitCode value
     * @param string $isoUnitCode
     * @return \StructType\TInvoiceLine
     */
    public function setIsoUnitCode($isoUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($isoUnitCode) && !is_string($isoUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isoUnitCode, true), gettype($isoUnitCode)), __LINE__);
        }
        $this->IsoUnitCode = $isoUnitCode;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \ArrayType\ArrayOfTTaxTotal|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param \ArrayType\ArrayOfTTaxTotal $taxTotal
     * @return \StructType\TInvoiceLine
     */
    public function setTaxTotal(\ArrayType\ArrayOfTTaxTotal $taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get CurrencyID value
     * @return string|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @param string $currencyID
     * @return \StructType\TInvoiceLine
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: string
        if (!is_null($currencyID) && !is_string($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyID, true), gettype($currencyID)), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \StructType\TDeliveryType|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \StructType\TDeliveryType $delivery
     * @return \StructType\TInvoiceLine
     */
    public function setDelivery(\StructType\TDeliveryType $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \StructType\TTaxTotal|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * Set WithholdingTaxTotal value
     * @param \StructType\TTaxTotal $withholdingTaxTotal
     * @return \StructType\TInvoiceLine
     */
    public function setWithholdingTaxTotal(\StructType\TTaxTotal $withholdingTaxTotal = null)
    {
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Get OriginCountryIdentificationCode value
     * @return string|null
     */
    public function getOriginCountryIdentificationCode()
    {
        return $this->OriginCountryIdentificationCode;
    }
    /**
     * Set OriginCountryIdentificationCode value
     * @param string $originCountryIdentificationCode
     * @return \StructType\TInvoiceLine
     */
    public function setOriginCountryIdentificationCode($originCountryIdentificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCountryIdentificationCode) && !is_string($originCountryIdentificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCountryIdentificationCode, true), gettype($originCountryIdentificationCode)), __LINE__);
        }
        $this->OriginCountryIdentificationCode = $originCountryIdentificationCode;
        return $this;
    }
    /**
     * Get OriginCountryName value
     * @return string|null
     */
    public function getOriginCountryName()
    {
        return $this->OriginCountryName;
    }
    /**
     * Set OriginCountryName value
     * @param string $originCountryName
     * @return \StructType\TInvoiceLine
     */
    public function setOriginCountryName($originCountryName = null)
    {
        // validation for constraint: string
        if (!is_null($originCountryName) && !is_string($originCountryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCountryName, true), gettype($originCountryName)), __LINE__);
        }
        $this->OriginCountryName = $originCountryName;
        return $this;
    }
    /**
     * Get ClassificationCode value
     * @return string|null
     */
    public function getClassificationCode()
    {
        return $this->ClassificationCode;
    }
    /**
     * Set ClassificationCode value
     * @param string $classificationCode
     * @return \StructType\TInvoiceLine
     */
    public function setClassificationCode($classificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($classificationCode) && !is_string($classificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificationCode, true), gettype($classificationCode)), __LINE__);
        }
        $this->ClassificationCode = $classificationCode;
        return $this;
    }
    /**
     * Get ClassificationListName value
     * @return string|null
     */
    public function getClassificationListName()
    {
        return $this->ClassificationListName;
    }
    /**
     * Set ClassificationListName value
     * @param string $classificationListName
     * @return \StructType\TInvoiceLine
     */
    public function setClassificationListName($classificationListName = null)
    {
        // validation for constraint: string
        if (!is_null($classificationListName) && !is_string($classificationListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificationListName, true), gettype($classificationListName)), __LINE__);
        }
        $this->ClassificationListName = $classificationListName;
        return $this;
    }
    /**
     * Get ClassificationListVersionID value
     * @return string|null
     */
    public function getClassificationListVersionID()
    {
        return $this->ClassificationListVersionID;
    }
    /**
     * Set ClassificationListVersionID value
     * @param string $classificationListVersionID
     * @return \StructType\TInvoiceLine
     */
    public function setClassificationListVersionID($classificationListVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($classificationListVersionID) && !is_string($classificationListVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificationListVersionID, true), gettype($classificationListVersionID)), __LINE__);
        }
        $this->ClassificationListVersionID = $classificationListVersionID;
        return $this;
    }
    /**
     * Get ManufacturersItemIdentification value
     * @return string|null
     */
    public function getManufacturersItemIdentification()
    {
        return $this->ManufacturersItemIdentification;
    }
    /**
     * Set ManufacturersItemIdentification value
     * @param string $manufacturersItemIdentification
     * @return \StructType\TInvoiceLine
     */
    public function setManufacturersItemIdentification($manufacturersItemIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturersItemIdentification) && !is_string($manufacturersItemIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturersItemIdentification, true), gettype($manufacturersItemIdentification)), __LINE__);
        }
        $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        return $this;
    }
}
