<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TGibUser StructType
 * @subpackage Structs
 */
class TGibUser extends AbstractStructBase
{
    /**
     * The PartyIdentificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartyIdentificationID;
    /**
     * The Alias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alias;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The RegisterTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegisterTime;
    /**
     * The AliasType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AliasType;
    /**
     * The AliasCreationTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AliasCreationTime;
    /**
     * Constructor method for TGibUser
     * @uses TGibUser::setPartyIdentificationID()
     * @uses TGibUser::setAlias()
     * @uses TGibUser::setTitle()
     * @uses TGibUser::setType()
     * @uses TGibUser::setAccountType()
     * @uses TGibUser::setRegisterTime()
     * @uses TGibUser::setAliasType()
     * @uses TGibUser::setAliasCreationTime()
     * @param string $partyIdentificationID
     * @param string $alias
     * @param string $title
     * @param string $type
     * @param string $accountType
     * @param string $registerTime
     * @param string $aliasType
     * @param string $aliasCreationTime
     */
    public function __construct($partyIdentificationID = null, $alias = null, $title = null, $type = null, $accountType = null, $registerTime = null, $aliasType = null, $aliasCreationTime = null)
    {
        $this
            ->setPartyIdentificationID($partyIdentificationID)
            ->setAlias($alias)
            ->setTitle($title)
            ->setType($type)
            ->setAccountType($accountType)
            ->setRegisterTime($registerTime)
            ->setAliasType($aliasType)
            ->setAliasCreationTime($aliasCreationTime);
    }
    /**
     * Get PartyIdentificationID value
     * @return string|null
     */
    public function getPartyIdentificationID()
    {
        return $this->PartyIdentificationID;
    }
    /**
     * Set PartyIdentificationID value
     * @param string $partyIdentificationID
     * @return \StructType\TGibUser
     */
    public function setPartyIdentificationID($partyIdentificationID = null)
    {
        // validation for constraint: string
        if (!is_null($partyIdentificationID) && !is_string($partyIdentificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyIdentificationID, true), gettype($partyIdentificationID)), __LINE__);
        }
        $this->PartyIdentificationID = $partyIdentificationID;
        return $this;
    }
    /**
     * Get Alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->Alias;
    }
    /**
     * Set Alias value
     * @param string $alias
     * @return \StructType\TGibUser
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        $this->Alias = $alias;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\TGibUser
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\TGibUser
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \StructType\TGibUser
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get RegisterTime value
     * @return string|null
     */
    public function getRegisterTime()
    {
        return $this->RegisterTime;
    }
    /**
     * Set RegisterTime value
     * @param string $registerTime
     * @return \StructType\TGibUser
     */
    public function setRegisterTime($registerTime = null)
    {
        // validation for constraint: string
        if (!is_null($registerTime) && !is_string($registerTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registerTime, true), gettype($registerTime)), __LINE__);
        }
        $this->RegisterTime = $registerTime;
        return $this;
    }
    /**
     * Get AliasType value
     * @return string|null
     */
    public function getAliasType()
    {
        return $this->AliasType;
    }
    /**
     * Set AliasType value
     * @param string $aliasType
     * @return \StructType\TGibUser
     */
    public function setAliasType($aliasType = null)
    {
        // validation for constraint: string
        if (!is_null($aliasType) && !is_string($aliasType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasType, true), gettype($aliasType)), __LINE__);
        }
        $this->AliasType = $aliasType;
        return $this;
    }
    /**
     * Get AliasCreationTime value
     * @return string|null
     */
    public function getAliasCreationTime()
    {
        return $this->AliasCreationTime;
    }
    /**
     * Set AliasCreationTime value
     * @param string $aliasCreationTime
     * @return \StructType\TGibUser
     */
    public function setAliasCreationTime($aliasCreationTime = null)
    {
        // validation for constraint: string
        if (!is_null($aliasCreationTime) && !is_string($aliasCreationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasCreationTime, true), gettype($aliasCreationTime)), __LINE__);
        }
        $this->AliasCreationTime = $aliasCreationTime;
        return $this;
    }
}
