<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TEArchiveInvoiceInfo StructType
 * @subpackage Structs
 */
class TEArchiveInvoiceInfo extends AbstractStructBase
{
    /**
     * The SendingType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendingType;
    /**
     * The EArchiveType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EArchiveType;
    /**
     * The InternetSalesWebAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternetSalesWebAddress;
    /**
     * The InternetSalesPaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternetSalesPaymentType;
    /**
     * The InternetSalesPaymentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternetSalesPaymentDate;
    /**
     * The SenderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderName;
    /**
     * The SenderTcknVkn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderTcknVkn;
    /**
     * The SendDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendDate;
    /**
     * Constructor method for TEArchiveInvoiceInfo
     * @uses TEArchiveInvoiceInfo::setSendingType()
     * @uses TEArchiveInvoiceInfo::setEArchiveType()
     * @uses TEArchiveInvoiceInfo::setInternetSalesWebAddress()
     * @uses TEArchiveInvoiceInfo::setInternetSalesPaymentType()
     * @uses TEArchiveInvoiceInfo::setInternetSalesPaymentDate()
     * @uses TEArchiveInvoiceInfo::setSenderName()
     * @uses TEArchiveInvoiceInfo::setSenderTcknVkn()
     * @uses TEArchiveInvoiceInfo::setSendDate()
     * @param string $sendingType
     * @param string $eArchiveType
     * @param string $internetSalesWebAddress
     * @param string $internetSalesPaymentType
     * @param string $internetSalesPaymentDate
     * @param string $senderName
     * @param string $senderTcknVkn
     * @param string $sendDate
     */
    public function __construct($sendingType = null, $eArchiveType = null, $internetSalesWebAddress = null, $internetSalesPaymentType = null, $internetSalesPaymentDate = null, $senderName = null, $senderTcknVkn = null, $sendDate = null)
    {
        $this
            ->setSendingType($sendingType)
            ->setEArchiveType($eArchiveType)
            ->setInternetSalesWebAddress($internetSalesWebAddress)
            ->setInternetSalesPaymentType($internetSalesPaymentType)
            ->setInternetSalesPaymentDate($internetSalesPaymentDate)
            ->setSenderName($senderName)
            ->setSenderTcknVkn($senderTcknVkn)
            ->setSendDate($sendDate);
    }
    /**
     * Get SendingType value
     * @return string|null
     */
    public function getSendingType()
    {
        return $this->SendingType;
    }
    /**
     * Set SendingType value
     * @param string $sendingType
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setSendingType($sendingType = null)
    {
        // validation for constraint: string
        if (!is_null($sendingType) && !is_string($sendingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendingType, true), gettype($sendingType)), __LINE__);
        }
        $this->SendingType = $sendingType;
        return $this;
    }
    /**
     * Get EArchiveType value
     * @return string|null
     */
    public function getEArchiveType()
    {
        return $this->EArchiveType;
    }
    /**
     * Set EArchiveType value
     * @param string $eArchiveType
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setEArchiveType($eArchiveType = null)
    {
        // validation for constraint: string
        if (!is_null($eArchiveType) && !is_string($eArchiveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eArchiveType, true), gettype($eArchiveType)), __LINE__);
        }
        $this->EArchiveType = $eArchiveType;
        return $this;
    }
    /**
     * Get InternetSalesWebAddress value
     * @return string|null
     */
    public function getInternetSalesWebAddress()
    {
        return $this->InternetSalesWebAddress;
    }
    /**
     * Set InternetSalesWebAddress value
     * @param string $internetSalesWebAddress
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setInternetSalesWebAddress($internetSalesWebAddress = null)
    {
        // validation for constraint: string
        if (!is_null($internetSalesWebAddress) && !is_string($internetSalesWebAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internetSalesWebAddress, true), gettype($internetSalesWebAddress)), __LINE__);
        }
        $this->InternetSalesWebAddress = $internetSalesWebAddress;
        return $this;
    }
    /**
     * Get InternetSalesPaymentType value
     * @return string|null
     */
    public function getInternetSalesPaymentType()
    {
        return $this->InternetSalesPaymentType;
    }
    /**
     * Set InternetSalesPaymentType value
     * @param string $internetSalesPaymentType
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setInternetSalesPaymentType($internetSalesPaymentType = null)
    {
        // validation for constraint: string
        if (!is_null($internetSalesPaymentType) && !is_string($internetSalesPaymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internetSalesPaymentType, true), gettype($internetSalesPaymentType)), __LINE__);
        }
        $this->InternetSalesPaymentType = $internetSalesPaymentType;
        return $this;
    }
    /**
     * Get InternetSalesPaymentDate value
     * @return string|null
     */
    public function getInternetSalesPaymentDate()
    {
        return $this->InternetSalesPaymentDate;
    }
    /**
     * Set InternetSalesPaymentDate value
     * @param string $internetSalesPaymentDate
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setInternetSalesPaymentDate($internetSalesPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($internetSalesPaymentDate) && !is_string($internetSalesPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internetSalesPaymentDate, true), gettype($internetSalesPaymentDate)), __LINE__);
        }
        $this->InternetSalesPaymentDate = $internetSalesPaymentDate;
        return $this;
    }
    /**
     * Get SenderName value
     * @return string|null
     */
    public function getSenderName()
    {
        return $this->SenderName;
    }
    /**
     * Set SenderName value
     * @param string $senderName
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setSenderName($senderName = null)
    {
        // validation for constraint: string
        if (!is_null($senderName) && !is_string($senderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderName, true), gettype($senderName)), __LINE__);
        }
        $this->SenderName = $senderName;
        return $this;
    }
    /**
     * Get SenderTcknVkn value
     * @return string|null
     */
    public function getSenderTcknVkn()
    {
        return $this->SenderTcknVkn;
    }
    /**
     * Set SenderTcknVkn value
     * @param string $senderTcknVkn
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setSenderTcknVkn($senderTcknVkn = null)
    {
        // validation for constraint: string
        if (!is_null($senderTcknVkn) && !is_string($senderTcknVkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderTcknVkn, true), gettype($senderTcknVkn)), __LINE__);
        }
        $this->SenderTcknVkn = $senderTcknVkn;
        return $this;
    }
    /**
     * Get SendDate value
     * @return string|null
     */
    public function getSendDate()
    {
        return $this->SendDate;
    }
    /**
     * Set SendDate value
     * @param string $sendDate
     * @return \StructType\TEArchiveInvoiceInfo
     */
    public function setSendDate($sendDate = null)
    {
        // validation for constraint: string
        if (!is_null($sendDate) && !is_string($sendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendDate, true), gettype($sendDate)), __LINE__);
        }
        $this->SendDate = $sendDate;
        return $this;
    }
}
