<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TDeliveryType StructType
 * @subpackage Structs
 */
class TDeliveryType extends AbstractStructBase
{
    /**
     * The ActualPackageQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualPackageQuantity;
    /**
     * The DeliveryTermsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTermsID;
    /**
     * The ActualPackageID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActualPackageID;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackagingTypeCode;
    /**
     * The TransportModeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransportModeCode;
    /**
     * The GTIPNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GTIPNo;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TDeliveryAddressType
     */
    public $DeliveryAddress;
    /**
     * Constructor method for TDeliveryType
     * @uses TDeliveryType::setActualPackageQuantity()
     * @uses TDeliveryType::setDeliveryTermsID()
     * @uses TDeliveryType::setActualPackageID()
     * @uses TDeliveryType::setPackagingTypeCode()
     * @uses TDeliveryType::setTransportModeCode()
     * @uses TDeliveryType::setGTIPNo()
     * @uses TDeliveryType::setDeliveryAddress()
     * @param float $actualPackageQuantity
     * @param string $deliveryTermsID
     * @param string $actualPackageID
     * @param string $packagingTypeCode
     * @param string $transportModeCode
     * @param string $gTIPNo
     * @param \StructType\TDeliveryAddressType $deliveryAddress
     */
    public function __construct($actualPackageQuantity = null, $deliveryTermsID = null, $actualPackageID = null, $packagingTypeCode = null, $transportModeCode = null, $gTIPNo = null, \StructType\TDeliveryAddressType $deliveryAddress = null)
    {
        $this
            ->setActualPackageQuantity($actualPackageQuantity)
            ->setDeliveryTermsID($deliveryTermsID)
            ->setActualPackageID($actualPackageID)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setTransportModeCode($transportModeCode)
            ->setGTIPNo($gTIPNo)
            ->setDeliveryAddress($deliveryAddress);
    }
    /**
     * Get ActualPackageQuantity value
     * @return float
     */
    public function getActualPackageQuantity()
    {
        return $this->ActualPackageQuantity;
    }
    /**
     * Set ActualPackageQuantity value
     * @param float $actualPackageQuantity
     * @return \StructType\TDeliveryType
     */
    public function setActualPackageQuantity($actualPackageQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($actualPackageQuantity) && !(is_float($actualPackageQuantity) || is_numeric($actualPackageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actualPackageQuantity, true), gettype($actualPackageQuantity)), __LINE__);
        }
        $this->ActualPackageQuantity = $actualPackageQuantity;
        return $this;
    }
    /**
     * Get DeliveryTermsID value
     * @return string|null
     */
    public function getDeliveryTermsID()
    {
        return $this->DeliveryTermsID;
    }
    /**
     * Set DeliveryTermsID value
     * @param string $deliveryTermsID
     * @return \StructType\TDeliveryType
     */
    public function setDeliveryTermsID($deliveryTermsID = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTermsID) && !is_string($deliveryTermsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTermsID, true), gettype($deliveryTermsID)), __LINE__);
        }
        $this->DeliveryTermsID = $deliveryTermsID;
        return $this;
    }
    /**
     * Get ActualPackageID value
     * @return string|null
     */
    public function getActualPackageID()
    {
        return $this->ActualPackageID;
    }
    /**
     * Set ActualPackageID value
     * @param string $actualPackageID
     * @return \StructType\TDeliveryType
     */
    public function setActualPackageID($actualPackageID = null)
    {
        // validation for constraint: string
        if (!is_null($actualPackageID) && !is_string($actualPackageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualPackageID, true), gettype($actualPackageID)), __LINE__);
        }
        $this->ActualPackageID = $actualPackageID;
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * @return string|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }
    /**
     * Set PackagingTypeCode value
     * @param string $packagingTypeCode
     * @return \StructType\TDeliveryType
     */
    public function setPackagingTypeCode($packagingTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packagingTypeCode) && !is_string($packagingTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagingTypeCode, true), gettype($packagingTypeCode)), __LINE__);
        }
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }
    /**
     * Get TransportModeCode value
     * @return string|null
     */
    public function getTransportModeCode()
    {
        return $this->TransportModeCode;
    }
    /**
     * Set TransportModeCode value
     * @param string $transportModeCode
     * @return \StructType\TDeliveryType
     */
    public function setTransportModeCode($transportModeCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportModeCode) && !is_string($transportModeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportModeCode, true), gettype($transportModeCode)), __LINE__);
        }
        $this->TransportModeCode = $transportModeCode;
        return $this;
    }
    /**
     * Get GTIPNo value
     * @return string|null
     */
    public function getGTIPNo()
    {
        return $this->GTIPNo;
    }
    /**
     * Set GTIPNo value
     * @param string $gTIPNo
     * @return \StructType\TDeliveryType
     */
    public function setGTIPNo($gTIPNo = null)
    {
        // validation for constraint: string
        if (!is_null($gTIPNo) && !is_string($gTIPNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTIPNo, true), gettype($gTIPNo)), __LINE__);
        }
        $this->GTIPNo = $gTIPNo;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \StructType\TDeliveryAddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \StructType\TDeliveryAddressType $deliveryAddress
     * @return \StructType\TDeliveryType
     */
    public function setDeliveryAddress(\StructType\TDeliveryAddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
}
