<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription StructType
 * @subpackage Structs
 */
class Subscription extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The RegulatorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegulatorId;
    /**
     * The SoftwareId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SoftwareId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The RegulatorName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegulatorName;
    /**
     * The SoftwareKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareKey;
    /**
     * The SoftwareName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareName;
    /**
     * Constructor method for Subscription
     * @uses Subscription::setId()
     * @uses Subscription::setProductId()
     * @uses Subscription::setCustomerId()
     * @uses Subscription::setRegulatorId()
     * @uses Subscription::setSoftwareId()
     * @uses Subscription::setProductName()
     * @uses Subscription::setCustomerName()
     * @uses Subscription::setRegulatorName()
     * @uses Subscription::setSoftwareKey()
     * @uses Subscription::setSoftwareName()
     * @param int $id
     * @param int $productId
     * @param int $customerId
     * @param int $regulatorId
     * @param int $softwareId
     * @param string $productName
     * @param string $customerName
     * @param string $regulatorName
     * @param string $softwareKey
     * @param string $softwareName
     */
    public function __construct($id = null, $productId = null, $customerId = null, $regulatorId = null, $softwareId = null, $productName = null, $customerName = null, $regulatorName = null, $softwareKey = null, $softwareName = null)
    {
        $this
            ->setId($id)
            ->setProductId($productId)
            ->setCustomerId($customerId)
            ->setRegulatorId($regulatorId)
            ->setSoftwareId($softwareId)
            ->setProductName($productName)
            ->setCustomerName($customerName)
            ->setRegulatorName($regulatorName)
            ->setSoftwareKey($softwareKey)
            ->setSoftwareName($softwareName);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Subscription
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ProductId value
     * @return int
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\Subscription
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\Subscription
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get RegulatorId value
     * @return int
     */
    public function getRegulatorId()
    {
        return $this->RegulatorId;
    }
    /**
     * Set RegulatorId value
     * @param int $regulatorId
     * @return \StructType\Subscription
     */
    public function setRegulatorId($regulatorId = null)
    {
        // validation for constraint: int
        if (!is_null($regulatorId) && !(is_int($regulatorId) || ctype_digit($regulatorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regulatorId, true), gettype($regulatorId)), __LINE__);
        }
        $this->RegulatorId = $regulatorId;
        return $this;
    }
    /**
     * Get SoftwareId value
     * @return int
     */
    public function getSoftwareId()
    {
        return $this->SoftwareId;
    }
    /**
     * Set SoftwareId value
     * @param int $softwareId
     * @return \StructType\Subscription
     */
    public function setSoftwareId($softwareId = null)
    {
        // validation for constraint: int
        if (!is_null($softwareId) && !(is_int($softwareId) || ctype_digit($softwareId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($softwareId, true), gettype($softwareId)), __LINE__);
        }
        $this->SoftwareId = $softwareId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\Subscription
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \StructType\Subscription
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get RegulatorName value
     * @return string|null
     */
    public function getRegulatorName()
    {
        return $this->RegulatorName;
    }
    /**
     * Set RegulatorName value
     * @param string $regulatorName
     * @return \StructType\Subscription
     */
    public function setRegulatorName($regulatorName = null)
    {
        // validation for constraint: string
        if (!is_null($regulatorName) && !is_string($regulatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regulatorName, true), gettype($regulatorName)), __LINE__);
        }
        $this->RegulatorName = $regulatorName;
        return $this;
    }
    /**
     * Get SoftwareKey value
     * @return string|null
     */
    public function getSoftwareKey()
    {
        return $this->SoftwareKey;
    }
    /**
     * Set SoftwareKey value
     * @param string $softwareKey
     * @return \StructType\Subscription
     */
    public function setSoftwareKey($softwareKey = null)
    {
        // validation for constraint: string
        if (!is_null($softwareKey) && !is_string($softwareKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareKey, true), gettype($softwareKey)), __LINE__);
        }
        $this->SoftwareKey = $softwareKey;
        return $this;
    }
    /**
     * Get SoftwareName value
     * @return string|null
     */
    public function getSoftwareName()
    {
        return $this->SoftwareName;
    }
    /**
     * Set SoftwareName value
     * @param string $softwareName
     * @return \StructType\Subscription
     */
    public function setSoftwareName($softwareName = null)
    {
        // validation for constraint: string
        if (!is_null($softwareName) && !is_string($softwareName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareName, true), gettype($softwareName)), __LINE__);
        }
        $this->SoftwareName = $softwareName;
        return $this;
    }
}
