<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendInvoiceStatus StructType
 * @subpackage Structs
 */
class SendInvoiceStatus extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The loginInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TLoginInfo
     */
    public $loginInfo;
    /**
     * The uuids
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $uuids;
    /**
     * Constructor method for SendInvoiceStatus
     * @uses SendInvoiceStatus::setStatus()
     * @uses SendInvoiceStatus::setLoginInfo()
     * @uses SendInvoiceStatus::setUuids()
     * @param string $status
     * @param \StructType\TLoginInfo $loginInfo
     * @param \ArrayType\ArrayOfString $uuids
     */
    public function __construct($status = null, \StructType\TLoginInfo $loginInfo = null, \ArrayType\ArrayOfString $uuids = null)
    {
        $this
            ->setStatus($status)
            ->setLoginInfo($loginInfo)
            ->setUuids($uuids);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\TDocumentResponseStatus::valueIsValid()
     * @uses \EnumType\TDocumentResponseStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SendInvoiceStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TDocumentResponseStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TDocumentResponseStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\TDocumentResponseStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get loginInfo value
     * @return \StructType\TLoginInfo|null
     */
    public function getLoginInfo()
    {
        return $this->loginInfo;
    }
    /**
     * Set loginInfo value
     * @param \StructType\TLoginInfo $loginInfo
     * @return \StructType\SendInvoiceStatus
     */
    public function setLoginInfo(\StructType\TLoginInfo $loginInfo = null)
    {
        $this->loginInfo = $loginInfo;
        return $this;
    }
    /**
     * Get uuids value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getUuids()
    {
        return $this->uuids;
    }
    /**
     * Set uuids value
     * @param \ArrayType\ArrayOfString $uuids
     * @return \StructType\SendInvoiceStatus
     */
    public function setUuids(\ArrayType\ArrayOfString $uuids = null)
    {
        $this->uuids = $uuids;
        return $this;
    }
}
