<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckUser StructType
 * @subpackage Structs
 */
class CheckUser extends AbstractStructBase
{
    /**
     * The loginInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TLoginInfo
     */
    public $loginInfo;
    /**
     * The CustomerPartyIdentificationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerPartyIdentificationId;
    /**
     * Constructor method for CheckUser
     * @uses CheckUser::setLoginInfo()
     * @uses CheckUser::setCustomerPartyIdentificationId()
     * @param \StructType\TLoginInfo $loginInfo
     * @param string $customerPartyIdentificationId
     */
    public function __construct(\StructType\TLoginInfo $loginInfo = null, $customerPartyIdentificationId = null)
    {
        $this
            ->setLoginInfo($loginInfo)
            ->setCustomerPartyIdentificationId($customerPartyIdentificationId);
    }
    /**
     * Get loginInfo value
     * @return \StructType\TLoginInfo|null
     */
    public function getLoginInfo()
    {
        return $this->loginInfo;
    }
    /**
     * Set loginInfo value
     * @param \StructType\TLoginInfo $loginInfo
     * @return \StructType\CheckUser
     */
    public function setLoginInfo(\StructType\TLoginInfo $loginInfo = null)
    {
        $this->loginInfo = $loginInfo;
        return $this;
    }
    /**
     * Get CustomerPartyIdentificationId value
     * @return string|null
     */
    public function getCustomerPartyIdentificationId()
    {
        return $this->CustomerPartyIdentificationId;
    }
    /**
     * Set CustomerPartyIdentificationId value
     * @param string $customerPartyIdentificationId
     * @return \StructType\CheckUser
     */
    public function setCustomerPartyIdentificationId($customerPartyIdentificationId = null)
    {
        // validation for constraint: string
        if (!is_null($customerPartyIdentificationId) && !is_string($customerPartyIdentificationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPartyIdentificationId, true), gettype($customerPartyIdentificationId)), __LINE__);
        }
        $this->CustomerPartyIdentificationId = $customerPartyIdentificationId;
        return $this;
    }
}
