<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sandbox ServiceType
 * @subpackage Services
 */
class Sandbox extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SandboxInvoice
     * Meta information extracted from the WSDL
     * - documentation: Sends your enveloped invoices to regulator and GIB systems.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SandboxInvoice $parameters
     * @return \StructType\SandboxInvoiceResponse|bool
     */
    public function SandboxInvoice(\StructType\SandboxInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SandboxInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SandboxInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
