<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetInvoiceStatus
     * Meta information extracted from the WSDL
     * - documentation: Returns current statuses of invoices in status request model.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceStatus $parameters
     * @return \StructType\GetInvoiceStatusResponse|bool
     */
    public function GetInvoiceStatus(\StructType\GetInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInboxInvoiceStatus
     * Meta information extracted from the WSDL
     * - documentation: Returns current statuses of incoming invoices in status request model.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInboxInvoiceStatus $parameters
     * @return \StructType\GetInboxInvoiceStatusResponse|bool
     */
    public function GetInboxInvoiceStatus(\StructType\GetInboxInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInboxInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTestInvoiceStatus
     * Meta information extracted from the WSDL
     * - documentation: Returns current statuses of invoices in status request model.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTestInvoiceStatus $parameters
     * @return \StructType\GetTestInvoiceStatusResponse|bool
     */
    public function GetTestInvoiceStatus(\StructType\GetTestInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTestInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInboxInvoices
     * Meta information extracted from the WSDL
     * - documentation: Returns inbox invoices.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInboxInvoices $parameters
     * @return \StructType\GetInboxInvoicesResponse|bool
     */
    public function GetInboxInvoices(\StructType\GetInboxInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInboxInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTestInboxInvoices
     * Meta information extracted from the WSDL
     * - documentation: Returns inbox invoices.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTestInboxInvoices $parameters
     * @return \StructType\GetTestInboxInvoicesResponse|bool
     */
    public function GetTestInboxInvoices(\StructType\GetTestInboxInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTestInboxInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInboxInvoice
     * Meta information extracted from the WSDL
     * - documentation: Returns spesified invoice as object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInboxInvoice $parameters
     * @return \StructType\GetInboxInvoiceResponse|bool
     */
    public function GetInboxInvoice(\StructType\GetInboxInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInboxInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebKey
     * Meta information extracted from the WSDL
     * - documentation: [ShortLink Service] Returns WEB_KEY. Only works with E-Archive Invoice.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebKey $parameters
     * @return \StructType\GetWebKeyResponse|bool
     */
    public function GetWebKey(\StructType\GetWebKey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoice
     * Meta information extracted from the WSDL
     * - documentation: Returns invoice details for specified uuid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoice $parameters
     * @return \StructType\GetInvoiceResponse|bool
     */
    public function GetInvoice(\StructType\GetInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTestInvoice
     * Meta information extracted from the WSDL
     * - documentation: Returns invoice details for specified uuid.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTestInvoice $parameters
     * @return \StructType\GetTestInvoiceResponse|bool
     */
    public function GetTestInvoice(\StructType\GetTestInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTestInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetInboxInvoiceResponse|\StructType\GetInboxInvoicesResponse|\StructType\GetInboxInvoiceStatusResponse|\StructType\GetInvoiceResponse|\StructType\GetInvoiceStatusResponse|\StructType\GetTestInboxInvoicesResponse|\StructType\GetTestInvoiceResponse|\StructType\GetTestInvoiceStatusResponse|\StructType\GetWebKeyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
