<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InvoiceStatusType EnumType
 * @subpackage Enumerations
 */
class InvoiceStatusType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Approved'
     * @return string 'Approved'
     */
    const VALUE_APPROVED = 'Approved';
    /**
     * Constant for value 'WaitingForApprovement'
     * @return string 'WaitingForApprovement'
     */
    const VALUE_WAITING_FOR_APPROVEMENT = 'WaitingForApprovement';
    /**
     * Constant for value 'Declined'
     * @return string 'Declined'
     */
    const VALUE_DECLINED = 'Declined';
    /**
     * Constant for value 'Return'
     * @return string 'Return'
     */
    const VALUE_RETURN = 'Return';
    /**
     * Constant for value 'eArchiveCancelled'
     * @return string 'eArchiveCancelled'
     */
    const VALUE_E_ARCHIVE_CANCELLED = 'eArchiveCancelled';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Draft'
     * @return string 'Draft'
     */
    const VALUE_DRAFT = 'Draft';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'Queued'
     * @return string 'Queued'
     */
    const VALUE_QUEUED = 'Queued';
    /**
     * Constant for value 'Processing'
     * @return string 'Processing'
     */
    const VALUE_PROCESSING = 'Processing';
    /**
     * Constant for value 'SentToGib'
     * @return string 'SentToGib'
     */
    const VALUE_SENT_TO_GIB = 'SentToGib';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return allowed values
     * @uses self::VALUE_APPROVED
     * @uses self::VALUE_WAITING_FOR_APPROVEMENT
     * @uses self::VALUE_DECLINED
     * @uses self::VALUE_RETURN
     * @uses self::VALUE_E_ARCHIVE_CANCELLED
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_QUEUED
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_SENT_TO_GIB
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPROVED,
            self::VALUE_WAITING_FOR_APPROVEMENT,
            self::VALUE_DECLINED,
            self::VALUE_RETURN,
            self::VALUE_E_ARCHIVE_CANCELLED,
            self::VALUE_PENDING,
            self::VALUE_DRAFT,
            self::VALUE_CANCELLED,
            self::VALUE_QUEUED,
            self::VALUE_PROCESSING,
            self::VALUE_SENT_TO_GIB,
            self::VALUE_ERROR,
        );
    }
}
