<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DataType EnumType
 * @subpackage Enumerations
 */
class DataType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CSharp'
     * @return string 'CSharp'
     */
    const VALUE_CSHARP = 'CSharp';
    /**
     * Constant for value 'Xml'
     * @return string 'Xml'
     */
    const VALUE_XML = 'Xml';
    /**
     * Constant for value 'Json'
     * @return string 'Json'
     */
    const VALUE_JSON = 'Json';
    /**
     * Return allowed values
     * @uses self::VALUE_CSHARP
     * @uses self::VALUE_XML
     * @uses self::VALUE_JSON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CSHARP,
            self::VALUE_XML,
            self::VALUE_JSON,
        );
    }
}
