<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTTaxTotal ArrayType
 * @subpackage Arrays
 */
class ArrayOfTTaxTotal extends AbstractStructArrayBase
{
    /**
     * The TTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TTaxTotal[]
     */
    public $TTaxTotal;
    /**
     * Constructor method for ArrayOfTTaxTotal
     * @uses ArrayOfTTaxTotal::setTTaxTotal()
     * @param \StructType\TTaxTotal[] $tTaxTotal
     */
    public function __construct(array $tTaxTotal = array())
    {
        $this
            ->setTTaxTotal($tTaxTotal);
    }
    /**
     * Get TTaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TTaxTotal[]|null
     */
    public function getTTaxTotal()
    {
        return isset($this->TTaxTotal) ? $this->TTaxTotal : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTTaxTotalForArrayConstraintsFromSetTTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTTaxTotalTTaxTotalItem) {
            // validation for constraint: itemType
            if (!$arrayOfTTaxTotalTTaxTotalItem instanceof \StructType\TTaxTotal) {
                $invalidValues[] = is_object($arrayOfTTaxTotalTTaxTotalItem) ? get_class($arrayOfTTaxTotalTTaxTotalItem) : sprintf('%s(%s)', gettype($arrayOfTTaxTotalTTaxTotalItem), var_export($arrayOfTTaxTotalTTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TTaxTotal property can only contain items of type \StructType\TTaxTotal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TTaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TTaxTotal[] $tTaxTotal
     * @return \ArrayType\ArrayOfTTaxTotal
     */
    public function setTTaxTotal(array $tTaxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($tTaxTotalArrayErrorMessage = self::validateTTaxTotalForArrayConstraintsFromSetTTaxTotal($tTaxTotal))) {
            throw new \InvalidArgumentException($tTaxTotalArrayErrorMessage, __LINE__);
        }
        if (is_null($tTaxTotal) || (is_array($tTaxTotal) && empty($tTaxTotal))) {
            unset($this->TTaxTotal);
        } else {
            $this->TTaxTotal = $tTaxTotal;
        }
        return $this;
    }
    /**
     * Add item to TTaxTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\TTaxTotal $item
     * @return \ArrayType\ArrayOfTTaxTotal
     */
    public function addToTTaxTotal(\StructType\TTaxTotal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TTaxTotal) {
            throw new \InvalidArgumentException(sprintf('The TTaxTotal property can only contain items of type \StructType\TTaxTotal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TTaxTotal[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TTaxTotal|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TTaxTotal|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TTaxTotal|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TTaxTotal|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TTaxTotal|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TTaxTotal
     */
    public function getAttributeName()
    {
        return 'TTaxTotal';
    }
}
