<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://entegredonusum.bulutix.com/EntegreInvoiceService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://entegredonusum.bulutix.com/EntegreInvoiceService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Version ServiceType
 */
$version = new \ServiceType\Version($options);
/**
 * Sample call for VersionInfo operation/method
 */
if ($version->VersionInfo(new \StructType\VersionInfo()) !== false) {
    print_r($version->getResult());
} else {
    print_r($version->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckLicense operation/method
 */
if ($check->CheckLicense(new \StructType\CheckLicense()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckUser operation/method
 */
if ($check->CheckUser(new \StructType\CheckUser()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckUserList operation/method
 */
if ($check->CheckUserList(new \StructType\CheckUserList()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckUserListAsync operation/method
 */
if ($check->CheckUserListAsync(new \StructType\CheckUserListAsync()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Dump ServiceType
 */
$dump = new \ServiceType\Dump($options);
/**
 * Sample call for DumpInvoice operation/method
 */
if ($dump->DumpInvoice(new \StructType\DumpInvoice()) !== false) {
    print_r($dump->getResult());
} else {
    print_r($dump->getLastError());
}
/**
 * Sample call for DumpGibUsers operation/method
 */
if ($dump->DumpGibUsers(new \StructType\DumpGibUsers()) !== false) {
    print_r($dump->getResult());
} else {
    print_r($dump->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendInvoice operation/method
 */
if ($send->SendInvoice(new \StructType\SendInvoice()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendDraftInvoice operation/method
 */
if ($send->SendDraftInvoice(new \StructType\SendDraftInvoice()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendInvoiceStatus operation/method
 */
if ($send->SendInvoiceStatus(new \StructType\SendInvoiceStatus()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetInvoiceStatus operation/method
 */
if ($get->GetInvoiceStatus(new \StructType\GetInvoiceStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInboxInvoiceStatus operation/method
 */
if ($get->GetInboxInvoiceStatus(new \StructType\GetInboxInvoiceStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTestInvoiceStatus operation/method
 */
if ($get->GetTestInvoiceStatus(new \StructType\GetTestInvoiceStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInboxInvoices operation/method
 */
if ($get->GetInboxInvoices(new \StructType\GetInboxInvoices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTestInboxInvoices operation/method
 */
if ($get->GetTestInboxInvoices(new \StructType\GetTestInboxInvoices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInboxInvoice operation/method
 */
if ($get->GetInboxInvoice(new \StructType\GetInboxInvoice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWebKey operation/method
 */
if ($get->GetWebKey(new \StructType\GetWebKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoice operation/method
 */
if ($get->GetInvoice(new \StructType\GetInvoice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTestInvoice operation/method
 */
if ($get->GetTestInvoice(new \StructType\GetTestInvoice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Sandbox ServiceType
 */
$sandbox = new \ServiceType\Sandbox($options);
/**
 * Sample call for SandboxInvoice operation/method
 */
if ($sandbox->SandboxInvoice(new \StructType\SandboxInvoice()) !== false) {
    print_r($sandbox->getResult());
} else {
    print_r($sandbox->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for TestInvoiceStatus operation/method
 */
if ($test->TestInvoiceStatus(new \StructType\TestInvoiceStatus()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
