<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TTaxTotal StructType
 * @subpackage Structs
 */
class TTaxTotal extends AbstractStructBase
{
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Percent;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxAmount;
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxableAmount;
    /**
     * The TaxSubtotalTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxSubtotalTaxAmount;
    /**
     * The HasTaxExemption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasTaxExemption;
    /**
     * The TaxTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxTypeCode;
    /**
     * The TaxTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxTypeName;
    /**
     * The TaxExemptionReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxExemptionReason;
    /**
     * The TaxExemptionReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxExemptionReasonCode;
    /**
     * Constructor method for TTaxTotal
     * @uses TTaxTotal::setPercent()
     * @uses TTaxTotal::setTaxAmount()
     * @uses TTaxTotal::setTaxableAmount()
     * @uses TTaxTotal::setTaxSubtotalTaxAmount()
     * @uses TTaxTotal::setHasTaxExemption()
     * @uses TTaxTotal::setTaxTypeCode()
     * @uses TTaxTotal::setTaxTypeName()
     * @uses TTaxTotal::setTaxExemptionReason()
     * @uses TTaxTotal::setTaxExemptionReasonCode()
     * @param float $percent
     * @param float $taxAmount
     * @param float $taxableAmount
     * @param float $taxSubtotalTaxAmount
     * @param bool $hasTaxExemption
     * @param string $taxTypeCode
     * @param string $taxTypeName
     * @param string $taxExemptionReason
     * @param string $taxExemptionReasonCode
     */
    public function __construct($percent = null, $taxAmount = null, $taxableAmount = null, $taxSubtotalTaxAmount = null, $hasTaxExemption = null, $taxTypeCode = null, $taxTypeName = null, $taxExemptionReason = null, $taxExemptionReasonCode = null)
    {
        $this
            ->setPercent($percent)
            ->setTaxAmount($taxAmount)
            ->setTaxableAmount($taxableAmount)
            ->setTaxSubtotalTaxAmount($taxSubtotalTaxAmount)
            ->setHasTaxExemption($hasTaxExemption)
            ->setTaxTypeCode($taxTypeCode)
            ->setTaxTypeName($taxTypeName)
            ->setTaxExemptionReason($taxExemptionReason)
            ->setTaxExemptionReasonCode($taxExemptionReasonCode);
    }
    /**
     * Get Percent value
     * @return float
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\TTaxTotal
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\TTaxTotal
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxableAmount value
     * @return float
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }
    /**
     * Set TaxableAmount value
     * @param float $taxableAmount
     * @return \StructType\TTaxTotal
     */
    public function setTaxableAmount($taxableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxableAmount) && !(is_float($taxableAmount) || is_numeric($taxableAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxableAmount, true), gettype($taxableAmount)), __LINE__);
        }
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }
    /**
     * Get TaxSubtotalTaxAmount value
     * @return float
     */
    public function getTaxSubtotalTaxAmount()
    {
        return $this->TaxSubtotalTaxAmount;
    }
    /**
     * Set TaxSubtotalTaxAmount value
     * @param float $taxSubtotalTaxAmount
     * @return \StructType\TTaxTotal
     */
    public function setTaxSubtotalTaxAmount($taxSubtotalTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxSubtotalTaxAmount) && !(is_float($taxSubtotalTaxAmount) || is_numeric($taxSubtotalTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxSubtotalTaxAmount, true), gettype($taxSubtotalTaxAmount)), __LINE__);
        }
        $this->TaxSubtotalTaxAmount = $taxSubtotalTaxAmount;
        return $this;
    }
    /**
     * Get HasTaxExemption value
     * @return bool
     */
    public function getHasTaxExemption()
    {
        return $this->HasTaxExemption;
    }
    /**
     * Set HasTaxExemption value
     * @param bool $hasTaxExemption
     * @return \StructType\TTaxTotal
     */
    public function setHasTaxExemption($hasTaxExemption = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTaxExemption) && !is_bool($hasTaxExemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTaxExemption, true), gettype($hasTaxExemption)), __LINE__);
        }
        $this->HasTaxExemption = $hasTaxExemption;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \StructType\TTaxTotal
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeCode, true), gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Get TaxTypeName value
     * @return string|null
     */
    public function getTaxTypeName()
    {
        return $this->TaxTypeName;
    }
    /**
     * Set TaxTypeName value
     * @param string $taxTypeName
     * @return \StructType\TTaxTotal
     */
    public function setTaxTypeName($taxTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeName) && !is_string($taxTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeName, true), gettype($taxTypeName)), __LINE__);
        }
        $this->TaxTypeName = $taxTypeName;
        return $this;
    }
    /**
     * Get TaxExemptionReason value
     * @return string|null
     */
    public function getTaxExemptionReason()
    {
        return $this->TaxExemptionReason;
    }
    /**
     * Set TaxExemptionReason value
     * @param string $taxExemptionReason
     * @return \StructType\TTaxTotal
     */
    public function setTaxExemptionReason($taxExemptionReason = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptionReason) && !is_string($taxExemptionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptionReason, true), gettype($taxExemptionReason)), __LINE__);
        }
        $this->TaxExemptionReason = $taxExemptionReason;
        return $this;
    }
    /**
     * Get TaxExemptionReasonCode value
     * @return string|null
     */
    public function getTaxExemptionReasonCode()
    {
        return $this->TaxExemptionReasonCode;
    }
    /**
     * Set TaxExemptionReasonCode value
     * @param string $taxExemptionReasonCode
     * @return \StructType\TTaxTotal
     */
    public function setTaxExemptionReasonCode($taxExemptionReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptionReasonCode) && !is_string($taxExemptionReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptionReasonCode, true), gettype($taxExemptionReasonCode)), __LINE__);
        }
        $this->TaxExemptionReasonCode = $taxExemptionReasonCode;
        return $this;
    }
}
