<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TPaymentMeans StructType
 * @subpackage Structs
 */
class TPaymentMeans extends AbstractStructBase
{
    /**
     * The PaymentMeansCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMeansCode;
    /**
     * The PaymentMeansName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMeansName;
    /**
     * The PaymentNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentNote;
    /**
     * The PaymentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentDate;
    /**
     * The PayeeFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayeeFinancialAccount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for TPaymentMeans
     * @uses TPaymentMeans::setPaymentMeansCode()
     * @uses TPaymentMeans::setPaymentMeansName()
     * @uses TPaymentMeans::setPaymentNote()
     * @uses TPaymentMeans::setPaymentDate()
     * @uses TPaymentMeans::setPayeeFinancialAccount()
     * @uses TPaymentMeans::setCurrencyCode()
     * @param string $paymentMeansCode
     * @param string $paymentMeansName
     * @param string $paymentNote
     * @param string $paymentDate
     * @param string $payeeFinancialAccount
     * @param string $currencyCode
     */
    public function __construct($paymentMeansCode = null, $paymentMeansName = null, $paymentNote = null, $paymentDate = null, $payeeFinancialAccount = null, $currencyCode = null)
    {
        $this
            ->setPaymentMeansCode($paymentMeansCode)
            ->setPaymentMeansName($paymentMeansName)
            ->setPaymentNote($paymentNote)
            ->setPaymentDate($paymentDate)
            ->setPayeeFinancialAccount($payeeFinancialAccount)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get PaymentMeansCode value
     * @return string|null
     */
    public function getPaymentMeansCode()
    {
        return $this->PaymentMeansCode;
    }
    /**
     * Set PaymentMeansCode value
     * @param string $paymentMeansCode
     * @return \StructType\TPaymentMeans
     */
    public function setPaymentMeansCode($paymentMeansCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMeansCode) && !is_string($paymentMeansCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMeansCode, true), gettype($paymentMeansCode)), __LINE__);
        }
        $this->PaymentMeansCode = $paymentMeansCode;
        return $this;
    }
    /**
     * Get PaymentMeansName value
     * @return string|null
     */
    public function getPaymentMeansName()
    {
        return $this->PaymentMeansName;
    }
    /**
     * Set PaymentMeansName value
     * @param string $paymentMeansName
     * @return \StructType\TPaymentMeans
     */
    public function setPaymentMeansName($paymentMeansName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMeansName) && !is_string($paymentMeansName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMeansName, true), gettype($paymentMeansName)), __LINE__);
        }
        $this->PaymentMeansName = $paymentMeansName;
        return $this;
    }
    /**
     * Get PaymentNote value
     * @return string|null
     */
    public function getPaymentNote()
    {
        return $this->PaymentNote;
    }
    /**
     * Set PaymentNote value
     * @param string $paymentNote
     * @return \StructType\TPaymentMeans
     */
    public function setPaymentNote($paymentNote = null)
    {
        // validation for constraint: string
        if (!is_null($paymentNote) && !is_string($paymentNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentNote, true), gettype($paymentNote)), __LINE__);
        }
        $this->PaymentNote = $paymentNote;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\TPaymentMeans
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get PayeeFinancialAccount value
     * @return string|null
     */
    public function getPayeeFinancialAccount()
    {
        return $this->PayeeFinancialAccount;
    }
    /**
     * Set PayeeFinancialAccount value
     * @param string $payeeFinancialAccount
     * @return \StructType\TPaymentMeans
     */
    public function setPayeeFinancialAccount($payeeFinancialAccount = null)
    {
        // validation for constraint: string
        if (!is_null($payeeFinancialAccount) && !is_string($payeeFinancialAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payeeFinancialAccount, true), gettype($payeeFinancialAccount)), __LINE__);
        }
        $this->PayeeFinancialAccount = $payeeFinancialAccount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\TPaymentMeans
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
}
