<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TLoginInfo StructType
 * @subpackage Structs
 */
class TLoginInfo extends AbstractStructBase
{
    /**
     * The Regulator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Regulator;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Product;
    /**
     * The PartyIdentificationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartyIdentificationId;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The SoftwareId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareId;
    /**
     * Constructor method for TLoginInfo
     * @uses TLoginInfo::setRegulator()
     * @uses TLoginInfo::setProduct()
     * @uses TLoginInfo::setPartyIdentificationId()
     * @uses TLoginInfo::setUsername()
     * @uses TLoginInfo::setPassword()
     * @uses TLoginInfo::setSoftwareId()
     * @param string $regulator
     * @param string $product
     * @param string $partyIdentificationId
     * @param string $username
     * @param string $password
     * @param string $softwareId
     */
    public function __construct($regulator = null, $product = null, $partyIdentificationId = null, $username = null, $password = null, $softwareId = null)
    {
        $this
            ->setRegulator($regulator)
            ->setProduct($product)
            ->setPartyIdentificationId($partyIdentificationId)
            ->setUsername($username)
            ->setPassword($password)
            ->setSoftwareId($softwareId);
    }
    /**
     * Get Regulator value
     * @return string
     */
    public function getRegulator()
    {
        return $this->Regulator;
    }
    /**
     * Set Regulator value
     * @uses \EnumType\Regulator::valueIsValid()
     * @uses \EnumType\Regulator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regulator
     * @return \StructType\TLoginInfo
     */
    public function setRegulator($regulator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Regulator::valueIsValid($regulator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Regulator', is_array($regulator) ? implode(', ', $regulator) : var_export($regulator, true), implode(', ', \EnumType\Regulator::getValidValues())), __LINE__);
        }
        $this->Regulator = $regulator;
        return $this;
    }
    /**
     * Get Product value
     * @return string
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @uses \EnumType\Product::valueIsValid()
     * @uses \EnumType\Product::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\TLoginInfo
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Product::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Product', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\Product::getValidValues())), __LINE__);
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Get PartyIdentificationId value
     * @return string|null
     */
    public function getPartyIdentificationId()
    {
        return $this->PartyIdentificationId;
    }
    /**
     * Set PartyIdentificationId value
     * @param string $partyIdentificationId
     * @return \StructType\TLoginInfo
     */
    public function setPartyIdentificationId($partyIdentificationId = null)
    {
        // validation for constraint: string
        if (!is_null($partyIdentificationId) && !is_string($partyIdentificationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyIdentificationId, true), gettype($partyIdentificationId)), __LINE__);
        }
        $this->PartyIdentificationId = $partyIdentificationId;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\TLoginInfo
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TLoginInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SoftwareId value
     * @return string|null
     */
    public function getSoftwareId()
    {
        return $this->SoftwareId;
    }
    /**
     * Set SoftwareId value
     * @param string $softwareId
     * @return \StructType\TLoginInfo
     */
    public function setSoftwareId($softwareId = null)
    {
        // validation for constraint: string
        if (!is_null($softwareId) && !is_string($softwareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareId, true), gettype($softwareId)), __LINE__);
        }
        $this->SoftwareId = $softwareId;
        return $this;
    }
}
